/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.util.helpers;

import com.blocklings.util.CropStruct;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class BlockHelper {
    private static List<Block> ores = new ArrayList<Block>();
    private static List<Block> logs;
    private static List<Block> leaves;
    private static List<Block> dirt;
    private static List<CropStruct> crops;

    public static boolean isOre(Block block) {
        return ores.contains(block);
    }

    public static double getOreValue(Block block) {
        return ores.indexOf(block);
    }

    public static boolean isLog(Block block) {
        return logs.contains(block);
    }

    public static boolean isLeaf(Block block) {
        return leaves.contains(block);
    }

    public static boolean isDirt(Block block) {
        return dirt.contains(block);
    }

    public static boolean isCrop(Block block) {
        for (CropStruct cropStruct : crops) {
            if (cropStruct.crop != block) continue;
            return true;
        }
        return false;
    }

    public static Item getSeed(Block block) {
        for (CropStruct cropStruct : crops) {
            if (cropStruct.crop != block) continue;
            return cropStruct.seed;
        }
        return Items.field_190931_a;
    }

    public static boolean isGrown(IBlockState blockState) {
        int age;
        int grownAge = BlockHelper.getGrownAge(blockState.func_177230_c());
        return grownAge == -1 || (age = BlockHelper.getAge(blockState)) >= grownAge;
    }

    public static int getGrownAge(Block block) {
        for (CropStruct cropStruct : crops) {
            if (cropStruct.crop != block) continue;
            return cropStruct.age;
        }
        return 0;
    }

    public static int getAge(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_185773_cZ) {
            return (Integer)blockState.func_177229_b((IProperty)BlockBeetroot.field_185531_a);
        }
        return (Integer)blockState.func_177229_b((IProperty)BlockCrops.field_176488_a);
    }

    static {
        ores.add(Blocks.field_150449_bY);
        ores.add(Blocks.field_150365_q);
        ores.add(Blocks.field_150366_p);
        ores.add(Blocks.field_150352_o);
        ores.add(Blocks.field_150369_x);
        ores.add(Blocks.field_150450_ax);
        ores.add(Blocks.field_150439_ay);
        ores.add(Blocks.field_150412_bA);
        ores.add(Blocks.field_150482_ag);
        logs = new ArrayList<Block>();
        logs.add(Blocks.field_150364_r);
        logs.add(Blocks.field_150363_s);
        leaves = new ArrayList<Block>();
        leaves.add((Block)Blocks.field_150362_t);
        leaves.add((Block)Blocks.field_150361_u);
        dirt = new ArrayList<Block>();
        dirt.add(Blocks.field_150346_d);
        dirt.add((Block)Blocks.field_150349_c);
        crops = new ArrayList<CropStruct>();
        crops.add(new CropStruct(Blocks.field_150464_aj, Items.field_151014_N, 7));
        crops.add(new CropStruct(Blocks.field_150469_bN, Items.field_151174_bG, 7));
        crops.add(new CropStruct(Blocks.field_150459_bM, Items.field_151172_bF, 7));
        crops.add(new CropStruct(Blocks.field_185773_cZ, Items.field_185163_cU, 3));
        crops.add(new CropStruct(Blocks.field_150423_aK, Items.field_190931_a, -1));
        crops.add(new CropStruct(Blocks.field_150440_ba, Items.field_190931_a, -1));
    }
}

