/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.util;

import com.blocklings.items.BlocklingsItems;
import com.blocklings.util.ResourceLocationBlocklings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlocklingType {
    public static List<BlocklingType> blocklingTypes = new ArrayList<BlocklingType>();
    public String textureName;
    public ResourceLocation entityTexture;
    public ModelResourceLocation itemModel;
    public ItemStack[] upgradeMaterials;
    public double bonusHealth;
    public double bonusAttackDamage;
    public double bonusAttackSpeed;
    public double bonusMovementSpeed;

    public static BlocklingType getTypeFromTextureName(String textureName) {
        for (BlocklingType blocklingType : blocklingTypes) {
            if (!textureName.equals(blocklingType.textureName)) continue;
            return blocklingType;
        }
        return blocklingTypes.get(0);
    }

    public static BlocklingType getTypeFromItemStack(ItemStack itemStack) {
        for (BlocklingType blocklingType : blocklingTypes) {
            for (ItemStack typeStack : blocklingType.upgradeMaterials) {
                if (!itemStack.func_77973_b().equals(typeStack.func_77973_b()) || itemStack.func_77960_j() != typeStack.func_77960_j()) continue;
                return blocklingType;
            }
        }
        return null;
    }

    public BlocklingType(String textureName, ItemStack itemStack, double bonusHealth, double bonusAttackDamage, double bonusAttackSpeed, double bonusMovementSpeed) {
        this.upgradeMaterials = new ItemStack[]{itemStack};
        this.textureName = textureName;
        this.entityTexture = new ResourceLocationBlocklings("textures/entities/blockling/" + textureName + ".png");
        this.itemModel = new ModelResourceLocation(BlocklingsItems.itemBlockling.getRegistryName() + textureName.substring(textureName.lastIndexOf("_")), "inventory");
        this.bonusHealth = bonusHealth;
        this.bonusAttackDamage = bonusAttackDamage;
        this.bonusAttackSpeed = bonusAttackSpeed;
        this.bonusMovementSpeed = bonusMovementSpeed;
    }

    public BlocklingType(String textureName, ItemStack[] upgradeMaterials, double bonusHealth, double bonusAttackDamage, double bonusAttackSpeed, double bonusMovementSpeed) {
        this.upgradeMaterials = upgradeMaterials;
        this.textureName = textureName;
        this.entityTexture = new ResourceLocationBlocklings("textures/entities/blockling/" + textureName + ".png");
        this.itemModel = new ModelResourceLocation(BlocklingsItems.itemBlockling.getRegistryName() + textureName.substring(textureName.lastIndexOf("_")), "inventory");
        this.bonusHealth = bonusHealth;
        this.bonusAttackDamage = bonusAttackDamage;
        this.bonusAttackSpeed = bonusAttackSpeed;
        this.bonusMovementSpeed = bonusMovementSpeed;
    }

    static {
        blocklingTypes.add(new BlocklingType("blockling_0", new ItemStack[]{new ItemStack((Block)Blocks.field_150349_c), new ItemStack(Blocks.field_150346_d)}, 0.0, 0.0, 0.0, 0.0));
        blocklingTypes.add(new BlocklingType("blockling_1", new ItemStack[]{new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Blocks.field_150363_s, 1, 1)}, 2.0, 1.0, 2.0, 1.0));
        blocklingTypes.add(new BlocklingType("blockling_2", new ItemStack(Blocks.field_150348_b), 5.0, 1.0, 1.0, -1.0));
        blocklingTypes.add(new BlocklingType("blockling_3", new ItemStack(Blocks.field_150339_S), 7.0, 3.0, 2.0, 0.0));
        blocklingTypes.add(new BlocklingType("blockling_4", new ItemStack(Blocks.field_150371_ca), 0.0, 4.0, 3.0, 2.0));
        blocklingTypes.add(new BlocklingType("blockling_5", new ItemStack(Blocks.field_150340_R), 0.0, 3.0, 5.0, 5.0));
        blocklingTypes.add(new BlocklingType("blockling_6", new ItemStack(Blocks.field_150368_y), 3.0, 3.0, 3.0, 2.0));
        blocklingTypes.add(new BlocklingType("blockling_7", new ItemStack(Blocks.field_150475_bE), 8.0, 5.0, 2.0, 2.0));
        blocklingTypes.add(new BlocklingType("blockling_8", new ItemStack(Blocks.field_150484_ah), 10.0, 10.0, 5.0, 3.0));
        blocklingTypes.add(new BlocklingType("blockling_9", new ItemStack(Blocks.field_150343_Z), 50.0, 10.0, -5.0, -5.0));
        blocklingTypes.add(new BlocklingType("blockling_10", new ItemStack(Blocks.field_150423_aK), 0.0, 3.0, 3.0, 3.0));
        blocklingTypes.add(new BlocklingType("blockling_11", new ItemStack(Blocks.field_150357_h), 5000.0, 2000.0, 3000.0, 0.001));
    }
}

