/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.render;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.models.ModelBlockling;
import com.blocklings.proxy.ClientProxy;
import com.blocklings.render.LayerBlocklingGel;
import com.blocklings.render.LayerHeldItem;
import com.blocklings.render.ModelChaosFlo;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jline.utils.Log;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockling
extends RenderLiving<EntityBlockling> {
    public static final Factory FACTORY = new Factory();
    private ModelBase blocklingModel = new ModelBlockling();
    private ModelBase slimeModel = new ModelSlime(16);
    private LayerBlocklingGel gel = new LayerBlocklingGel(this);
    private LayerHeldItem held = new LayerHeldItem((RenderLivingBase<?>)this);

    public RenderBlockling(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)new ModelBlockling(), 0.0f);
        this.func_177094_a(this.held);
    }

    public void doRender(EntityBlockling entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = 0.2f;
        if (entity.blocklingType.textureName == "melon_0") {
            this.renderMelon(entity, x, y + 0.21, z, entityYaw, partialTicks);
            this.field_77045_g = new ModelBase(){

                public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                    super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                }
            };
            this.field_177097_h.remove(this.gel);
            this.field_177097_h.remove(this.held);
            if (!this.field_177097_h.contains(this.held)) {
                this.field_177097_h.add(this.held);
            }
        } else if (entity.blocklingType.textureName == "slimey_0") {
            this.field_77045_g = this.slimeModel;
            if (!this.field_177097_h.contains(this.gel)) {
                this.func_177094_a(this.gel);
            }
            this.field_177097_h.remove(this.held);
            if (!this.field_177097_h.contains(this.held)) {
                this.field_177097_h.add(this.held);
            }
        } else if (entity.blocklingType.textureName == "chaosflo_0") {
            this.field_77045_g = new ModelChaosFlo();
            this.field_177097_h.remove(this.gel);
            this.field_177097_h.remove(this.held);
        } else {
            this.field_77045_g = this.blocklingModel;
            this.field_177097_h.remove(this.gel);
            if (!this.field_177097_h.contains(this.held)) {
                this.field_177097_h.add(this.held);
            }
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    private void renderMelon(EntityBlockling entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)(y + (double)(entity.field_70131_O / 2.0f) - (double)0.2f), (double)z);
        float val = 0.75f * entity.getBlocklingScale();
        if (entity.blocklingType.textureName == "melon_0") {
            val *= 1.1f;
        }
        GL11.glScalef((float)val, (float)val, (float)val);
        float rotatey = Math.abs(entity.field_184619_aG * 15.0f % 360.0f);
        if (entity.field_70721_aZ < 0.1f && rotatey >= 10.0f && rotatey <= 350.0f) {
            if (rotatey >= 10.0f && rotatey <= 180.0f) {
                entity.field_184619_aG -= 1.0f * partialTicks;
            } else if (rotatey <= 360.0f && rotatey >= 180.0f) {
                entity.field_184619_aG += 1.0f * partialTicks;
            }
        }
        GL11.glRotatef((float)(-entity.field_70758_at), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-90.0f + entity.field_184619_aG % 360.0f * 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        if (entity.field_70721_aZ > 0.99f) {
            Log.info((Object[])new Object[]{Float.valueOf(entity.field_70721_aZ)});
        }
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        GL11.glCallList((int)ClientProxy.sphereIdOutside);
        GL11.glCallList((int)ClientProxy.sphereIdInside);
        GL11.glPopMatrix();
    }

    protected void preRenderCallback(EntityBlockling blockling, float partialTicks) {
        float val = 0.75f * blockling.getBlocklingScale();
        if (blockling.blocklingType.textureName == "slimey_0") {
            val *= 1.1f;
        } else if (blockling.blocklingType.textureName == "chaosflo_0") {
            // empty if block
        }
        GlStateManager.func_179152_a((float)val, (float)val, (float)val);
    }

    protected void renderLivingLabel(EntityBlockling blockling, String label, double x, double y, double z, int maxDistance) {
        if (!blockling.isInGui) {
            super.func_147906_a((Entity)blockling, label, x, y, z, maxDistance);
        }
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityBlockling entity) {
        return entity.blocklingType.entityTexture;
    }

    public static class Factory
    implements IRenderFactory<EntityBlockling> {
        public Render<? super EntityBlockling> createRenderFor(RenderManager manager) {
            return new RenderBlockling(manager);
        }
    }
}

