/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.network;

import com.blocklings.abilities.AbilityGroup;
import com.blocklings.abilities.AbilityGroupType;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AbilitiesMessage
implements IMessage {
    AbilityGroup generalAbilities;
    AbilityGroup combatAbilities;
    AbilityGroup miningAbilities;
    AbilityGroup woodcuttingAbilities;
    AbilityGroup farmingAbilities;
    int id;

    public AbilitiesMessage() {
    }

    public AbilitiesMessage(AbilityGroup generalAbilities, AbilityGroup combatAbilities, AbilityGroup miningAbilities, AbilityGroup woodcuttingAbilities, AbilityGroup farmingAbilities, int entityID) {
        this.generalAbilities = generalAbilities;
        this.combatAbilities = combatAbilities;
        this.miningAbilities = miningAbilities;
        this.woodcuttingAbilities = woodcuttingAbilities;
        this.farmingAbilities = farmingAbilities;
        this.id = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.generalAbilities = new AbilityGroup(AbilityGroupType.GENERAL);
        this.combatAbilities = new AbilityGroup(AbilityGroupType.COMBAT);
        this.miningAbilities = new AbilityGroup(AbilityGroupType.MINING);
        this.woodcuttingAbilities = new AbilityGroup(AbilityGroupType.WOODCUTTING);
        this.farmingAbilities = new AbilityGroup(AbilityGroupType.FARMING);
        this.generalAbilities.readFromBuf(buf);
        this.combatAbilities.readFromBuf(buf);
        this.miningAbilities.readFromBuf(buf);
        this.woodcuttingAbilities.readFromBuf(buf);
        this.farmingAbilities.readFromBuf(buf);
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.generalAbilities.writeToBuf(buf);
        this.combatAbilities.writeToBuf(buf);
        this.miningAbilities.writeToBuf(buf);
        this.woodcuttingAbilities.writeToBuf(buf);
        this.farmingAbilities.writeToBuf(buf);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<AbilitiesMessage, IMessage> {
        public IMessage onMessage(AbilitiesMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient() && Blocklings.proxy.getPlayer(ctx) != null) {
                entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityBlockling) {
                    EntityBlockling blockling = (EntityBlockling)entity;
                    blockling.generalAbilities = message.generalAbilities;
                    blockling.combatAbilities = message.combatAbilities;
                    blockling.miningAbilities = message.miningAbilities;
                    blockling.woodcuttingAbilities = message.woodcuttingAbilities;
                    blockling.farmingAbilities = message.farmingAbilities;
                }
            } else if (ctx.side.isServer() && Blocklings.proxy.getPlayer(ctx) != null && (entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id)) instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.generalAbilities = message.generalAbilities;
                blockling.combatAbilities = message.combatAbilities;
                blockling.miningAbilities = message.miningAbilities;
                blockling.woodcuttingAbilities = message.woodcuttingAbilities;
                blockling.farmingAbilities = message.farmingAbilities;
            }
            return null;
        }
    }
}

