/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.abilities.AbilityGroup;
import com.blocklings.abilities.AbilityGroupType;
import com.blocklings.abilities.AbilityHelper;
import com.blocklings.entities.BlocklingAIAttackMelee;
import com.blocklings.entities.BlocklingAIFarming;
import com.blocklings.entities.BlocklingAIFollowOwner;
import com.blocklings.entities.BlocklingAIHunt;
import com.blocklings.entities.BlocklingAIMining;
import com.blocklings.entities.BlocklingAIOwnerHurtByTarget;
import com.blocklings.entities.BlocklingAIOwnerHurtTarget;
import com.blocklings.entities.BlocklingAIWanderAvoidWater;
import com.blocklings.entities.BlocklingAIWoodcutting;
import com.blocklings.entities.PathNavigateGroundBlockling;
import com.blocklings.inventories.InventoryBlockling;
import com.blocklings.items.ItemBlockling;
import com.blocklings.main.Blocklings;
import com.blocklings.network.AbilitiesMessage;
import com.blocklings.network.AnimationStateMessage;
import com.blocklings.network.AttackIntervalMessage;
import com.blocklings.network.AttackTimerMessage;
import com.blocklings.network.AttackingHandMessage;
import com.blocklings.network.AutoswitchIDMessage;
import com.blocklings.network.BlocklingTypeMessage;
import com.blocklings.network.ChoppingIntervalMessage;
import com.blocklings.network.CombatLevelMessage;
import com.blocklings.network.CombatXpMessage;
import com.blocklings.network.FarmingIntervalMessage;
import com.blocklings.network.FarmingLevelMessage;
import com.blocklings.network.FarmingXpMessage;
import com.blocklings.network.GuardIDMessage;
import com.blocklings.network.GuiIDMessage;
import com.blocklings.network.InvItemStackMessage;
import com.blocklings.network.IsInAttackRangeMessage;
import com.blocklings.network.MiningIntervalMessage;
import com.blocklings.network.MiningLevelMessage;
import com.blocklings.network.MiningTimerMessage;
import com.blocklings.network.MiningXpMessage;
import com.blocklings.network.NameMessage;
import com.blocklings.network.OpenGuiMessage;
import com.blocklings.network.ScaleMessage;
import com.blocklings.network.SkillPointsMessage;
import com.blocklings.network.StateIDMessage;
import com.blocklings.network.TaskIDMessage;
import com.blocklings.network.UnlockedSlotsMessage;
import com.blocklings.network.WoodcuttingLevelMessage;
import com.blocklings.network.WoodcuttingXpMessage;
import com.blocklings.util.BlocklingType;
import com.blocklings.util.helpers.EntityHelper;
import com.blocklings.util.helpers.GuiHelper;
import com.blocklings.util.helpers.ItemHelper;
import com.blocklings.util.helpers.NetworkHelper;
import com.blocklings.util.helpers.ToolHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlockling
extends EntityTameable
implements IEntityAdditionalSpawnData {
    public static final Random RANDOM = new Random();
    public static final double BASE_MAX_HEALTH = 10.0;
    public static final double BASE_MOVEMENT_SPEED = 0.5;
    public static final double BASE_ATTACK_DAMAGE = 1.0;
    public BlocklingType blocklingType = BlocklingType.blocklingTypes.get(0);
    public boolean isInAttackRange;
    public InventoryBlockling inv;
    private int unlockedSlots = 12;
    public AbilityGroup generalAbilities;
    public AbilityGroup combatAbilities;
    public AbilityGroup miningAbilities;
    public AbilityGroup woodcuttingAbilities;
    public AbilityGroup farmingAbilities;
    public boolean isInGui = false;
    private float scale;
    private AnimationState animationState = AnimationState.IDLE;
    private int guiID = 1;
    private EntityHelper.Task task = EntityHelper.Task.IDLE;
    private EntityHelper.Guard guard = EntityHelper.Guard.NOGUARD;
    private EntityHelper.State state = EntityHelper.State.WANDER;
    private int skillPoints = 0;
    private int combatLevel = 1;
    private int miningLevel = 1;
    private int woodcuttingLevel = 1;
    private int farmingLevel = 1;
    private int combatXp = 0;
    private int miningXp = 0;
    private int woodcuttingXp = 0;
    private int farmingXp = 0;
    private int attackInterval = 10;
    private int miningInterval = 20;
    private int choppingInterval = 20;
    private int farmingInterval = 20;
    private int attackTimer = -1;
    private int miningTimer = -1;
    private EnumHand attackingHand = EnumHand.MAIN_HAND;
    private byte autoswitchID = 0;
    private BlocklingAIFollowOwner aiFollow;
    private BlocklingAIWanderAvoidWater aiWander;
    private BlocklingAIAttackMelee aiAttackMelee;
    private BlocklingAIOwnerHurtByTarget aiOwnerHurtBy;
    private BlocklingAIOwnerHurtTarget aiOwnerHurt;
    private ItemStack leftHandStack = ItemStack.field_190927_a;
    private ItemStack rightHandStack = ItemStack.field_190927_a;
    private BlocklingAIMining aiMining;
    private BlocklingAIWoodcutting aiWoodcutting;
    private BlocklingAIFarming aiFarming;
    private BlocklingAIHunt aiHunt;
    private int regenTimer = -1;
    private int eatTimer = 0;

    public EntityBlockling(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setupInventory();
        this.unlockedSlots = 12;
        if (this.generalAbilities == null || this.generalAbilities.abilities.size() == 0) {
            this.generalAbilities = new AbilityGroup(AbilityGroupType.GENERAL);
            this.combatAbilities = new AbilityGroup(AbilityGroupType.COMBAT);
            this.miningAbilities = new AbilityGroup(AbilityGroupType.MINING);
            this.woodcuttingAbilities = new AbilityGroup(AbilityGroupType.WOODCUTTING);
            this.farmingAbilities = new AbilityGroup(AbilityGroupType.FARMING);
        }
        if (!this.field_70170_p.field_72995_K) {
            do {
                this.scale = 1.0f + (float)RANDOM.nextGaussian() / 15.0f;
            } while (this.scale < 0.6f || this.scale > 1.4f);
        }
        this.func_70105_a(0.7125f * this.scale, 0.7125f * this.scale);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateGroundBlockling((EntityLiving)this, worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiOwnerHurtBy = new BlocklingAIOwnerHurtByTarget(this);
        this.aiOwnerHurt = new BlocklingAIOwnerHurtTarget(this);
        this.aiAttackMelee = new BlocklingAIAttackMelee((EntityCreature)this, true);
        this.aiFollow = new BlocklingAIFollowOwner(this, 2.0f, 8.0f);
        this.aiWander = new BlocklingAIWanderAvoidWater(this, 1.0f);
        this.aiMining = new BlocklingAIMining(this);
        this.aiWoodcutting = new BlocklingAIWoodcutting(this);
        this.aiFarming = new BlocklingAIFarming(this);
        this.aiHunt = new BlocklingAIHunt(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackMelee);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiMining);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiWoodcutting);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiFarming);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollow);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtBy);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurt);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)this.aiHunt);
    }

    private void updateAI() {
        this.func_70904_g(this.state == EntityHelper.State.STAY);
    }

    public void func_70624_b(EntityLivingBase ent) {
        super.func_70624_b(ent);
    }

    public boolean func_70652_k(Entity entityIn) {
        float entityYaw;
        double damage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int fireAspect = 0;
        int knockBack = 0;
        if (this.hasTool()) {
            List<NBTTagCompound> enchantments = ToolHelper.getEnchantmentTagsFromTool(this.func_184586_b(this.calculateAttackingHand()));
            for (NBTTagCompound enchantmentTag : enchantments) {
                ToolHelper.Enchantment enchantment = ToolHelper.Enchantment.getEnchantmentFromTag(enchantmentTag);
                if (enchantment == ToolHelper.Enchantment.SHARPNESS) {
                    damage += 1.0 + (double)(enchantmentTag.func_74762_e("lvl") - 1) * 0.5;
                }
                if (enchantment == ToolHelper.Enchantment.BANEOFARTHROPODS && entityIn instanceof EntitySpider) {
                    damage += (double)enchantmentTag.func_74762_e("lvl") * 2.5;
                }
                if (enchantment == ToolHelper.Enchantment.SMITE && entityIn instanceof EntityZombie) {
                    damage += (double)enchantmentTag.func_74762_e("lvl") * 2.5;
                }
                if (enchantment == ToolHelper.Enchantment.FIREASPECT) {
                    fireAspect += enchantmentTag.func_74762_e("lvl") * 4;
                }
                if (enchantment != ToolHelper.Enchantment.KNOCKBACK) continue;
                knockBack += enchantmentTag.func_74762_e("lvl");
            }
            this.damageItem(this.calculateAttackingHand());
        }
        if (damage > (double)((EntityLiving)entityIn).func_110143_aJ()) {
            damage = Math.ceil(((EntityLiving)entityIn).func_110143_aJ());
        }
        float angle = 90.0f;
        float blocklingYaw = this.field_70177_z < 180.0f ? this.field_70177_z + 360.0f : this.field_70177_z;
        float f = entityYaw = entityIn.field_70177_z < 180.0f ? entityIn.field_70177_z + 360.0f : entityIn.field_70177_z;
        if (blocklingYaw - angle / 2.0f < entityYaw && blocklingYaw + angle / 2.0f > entityYaw) {
            if (this.combatAbilities.isAbilityAcquired(AbilityHelper.shinobi2)) {
                damage *= 3.0;
            } else if (this.combatAbilities.isAbilityAcquired(AbilityHelper.shinobi1)) {
                damage *= 2.0;
            }
        }
        ((EntityLiving)entityIn).func_70653_a((Entity)this, (float)knockBack, 1.0, 1.0);
        entityIn.func_70015_d(fireAspect);
        entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)damage));
        this.incrementCombatXp((int)(damage / 4.0) + 1);
        this.setAttackingHand(this.attackingHand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        return super.func_70652_k(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        float chanceToBlock;
        float f = this.combatAbilities.isAbilityAcquired(AbilityHelper.thickSkin3) ? 0.2f : (this.combatAbilities.isAbilityAcquired(AbilityHelper.thickSkin2) ? 0.1f : (chanceToBlock = this.combatAbilities.isAbilityAcquired(AbilityHelper.thickSkin1) ? 0.05f : 0.0f));
        if (chanceToBlock != 0.0f && this.field_70146_Z.nextFloat() < chanceToBlock) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void updateIsInAttackRange() {
        double dist;
        double sqDist;
        this.isInAttackRange = this.func_70638_az() != null ? (sqDist = this.func_70092_e(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v)) <= (dist = (double)(this.field_70130_N * 2.0f * this.field_70130_N * 2.0f + this.func_70638_az().field_70130_N)) * dist : false;
        NetworkHelper.sync(this.field_70170_p, new IsInAttackRangeMessage(this.isInAttackRange, this.func_145782_y()));
    }

    public EnumHand calculateAttackingHand() {
        if (this.hasWeapon(EnumHand.MAIN_HAND) && this.hasWeapon(EnumHand.OFF_HAND)) {
            return this.attackingHand;
        }
        if (this.hasWeapon(EnumHand.MAIN_HAND)) {
            return EnumHand.MAIN_HAND;
        }
        if (this.hasWeapon(EnumHand.OFF_HAND)) {
            return EnumHand.OFF_HAND;
        }
        if (this.hasTool(EnumHand.MAIN_HAND) && this.hasTool(EnumHand.OFF_HAND)) {
            return this.attackingHand;
        }
        return this.hasTool(EnumHand.MAIN_HAND) ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public boolean hasCorrectToolForJob() {
        return this.hasCorrectToolForJob(EnumHand.MAIN_HAND) || this.hasCorrectToolForJob(EnumHand.OFF_HAND);
    }

    public boolean hasCorrectToolForJob(EnumHand hand) {
        if (this.task == EntityHelper.Task.MINE) {
            return this.hasPickaxe(hand);
        }
        if (this.task == EntityHelper.Task.CHOP) {
            return this.hasAxe(hand);
        }
        if (this.task == EntityHelper.Task.FARM) {
            return this.hasHoe(hand);
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound c) {
        super.func_70014_b(c);
        c.func_74778_a("Name", this.func_95999_t());
        c.func_74778_a("BlocklingType", this.blocklingType.textureName);
        c.func_74768_a("UnlockedSlots", this.unlockedSlots);
        c.func_74776_a("Scale", this.scale);
        c.func_74768_a("GuiID", this.guiID);
        c.func_74774_a("AutoswitchID", this.autoswitchID);
        c.func_74768_a("TaskID", this.task.id);
        c.func_74768_a("GuardID", this.guard.id);
        c.func_74768_a("StateID", this.state.id);
        c.func_74768_a("CombatLevel", this.combatLevel);
        c.func_74768_a("MiningLevel", this.miningLevel);
        c.func_74768_a("WoodcuttingLevel", this.woodcuttingLevel);
        c.func_74768_a("FarmingLevel", this.farmingLevel);
        c.func_74768_a("CombatXp", this.combatXp);
        c.func_74768_a("MiningXp", this.miningXp);
        c.func_74768_a("WoodcuttingXp", this.woodcuttingXp);
        c.func_74768_a("FarmingXp", this.farmingXp);
        this.generalAbilities.writeToNBT(c);
        this.combatAbilities.writeToNBT(c);
        this.miningAbilities.writeToNBT(c);
        this.woodcuttingAbilities.writeToNBT(c);
        this.farmingAbilities.writeToNBT(c);
        c.func_74768_a("SkillPoints", this.skillPoints);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inv.func_70301_a(i);
            if (itemstack == null || itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        c.func_74782_a("items", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound c) {
        super.func_70037_a(c);
        this.func_96094_a(c.func_74779_i("Name"));
        this.blocklingType = BlocklingType.getTypeFromTextureName(c.func_74779_i("BlocklingType"));
        this.unlockedSlots = c.func_74762_e("UnlockedSlots");
        this.scale = c.func_74760_g("Scale");
        this.guiID = c.func_74762_e("GuiID");
        this.autoswitchID = c.func_74771_c("AutoswitchID");
        this.task = EntityHelper.Task.getFromID(c.func_74762_e("TaskID"));
        this.guard = EntityHelper.Guard.getFromID(c.func_74762_e("GuardID"));
        this.state = EntityHelper.State.getFromID(c.func_74762_e("StateID"));
        this.combatLevel = c.func_74762_e("CombatLevel");
        this.miningLevel = c.func_74762_e("MiningLevel");
        this.woodcuttingLevel = c.func_74762_e("WoodcuttingLevel");
        this.farmingLevel = c.func_74762_e("FarmingLevel");
        this.combatXp = c.func_74762_e("CombatXp");
        this.miningXp = c.func_74762_e("MiningXp");
        this.woodcuttingXp = c.func_74762_e("WoodcuttingXp");
        this.farmingXp = c.func_74762_e("FarmingXp");
        this.generalAbilities.initFromNBT(c);
        this.combatAbilities.initFromNBT(c);
        this.miningAbilities.initFromNBT(c);
        this.woodcuttingAbilities.initFromNBT(c);
        this.farmingAbilities.initFromNBT(c);
        this.skillPoints = c.func_74762_e("SkillPoints");
        NBTTagList tag = c.func_150295_c("items", 10);
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tag.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.inv.func_70302_i_()) continue;
            this.inv.func_70299_a(j, new ItemStack(nbttagcompound1));
        }
        this.setHeldItem(this.func_184614_ca(), EnumHand.MAIN_HAND);
        this.setHeldItem(this.func_184592_cb(), EnumHand.OFF_HAND);
        this.func_70105_a(0.7125f * this.scale, 0.7125f * this.scale);
        double d0 = (double)this.field_70130_N / 2.0;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
        this.updateAI();
    }

    public void writeSpawnData(ByteBuf buf) {
        AbilityHelper.writeSpawnData(buf, this);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blocklingType.textureName);
        buf.writeInt(this.unlockedSlots);
        buf.writeFloat(this.scale);
        buf.writeInt(this.animationState.ordinal());
        buf.writeInt(this.guiID);
        buf.writeByte((int)this.autoswitchID);
        buf.writeInt(this.task.id);
        buf.writeInt(this.guard.id);
        buf.writeInt(this.state.id);
        buf.writeInt(this.combatLevel);
        buf.writeInt(this.miningLevel);
        buf.writeInt(this.woodcuttingLevel);
        buf.writeInt(this.farmingLevel);
        buf.writeInt(this.combatXp);
        buf.writeInt(this.miningXp);
        buf.writeInt(this.woodcuttingXp);
        buf.writeInt(this.farmingXp);
        buf.writeInt(this.skillPoints);
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.inv.func_70301_a(i));
        }
    }

    public void readSpawnData(ByteBuf buf) {
        AbilityHelper.readSpawnData(buf, this);
        this.blocklingType = BlocklingType.getTypeFromTextureName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.unlockedSlots = buf.readInt();
        this.scale = buf.readFloat();
        this.animationState = AnimationState.values()[buf.readInt()];
        this.guiID = buf.readInt();
        this.autoswitchID = buf.readByte();
        this.task = EntityHelper.Task.getFromID(buf.readInt());
        this.guard = EntityHelper.Guard.getFromID(buf.readInt());
        this.state = EntityHelper.State.getFromID(buf.readInt());
        this.combatLevel = buf.readInt();
        this.miningLevel = buf.readInt();
        this.woodcuttingLevel = buf.readInt();
        this.farmingLevel = buf.readInt();
        this.combatXp = buf.readInt();
        this.miningXp = buf.readInt();
        this.woodcuttingXp = buf.readInt();
        this.farmingXp = buf.readInt();
        this.skillPoints = buf.readInt();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            this.inv.func_70299_a(i, ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        this.func_70105_a(0.7125f * this.scale, 0.7125f * this.scale);
        double d0 = (double)this.field_70130_N / 2.0;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
        this.updateAI();
    }

    public void func_70636_d() {
        double enderBoye;
        int regenLevel;
        super.func_70636_d();
        this.updateAI();
        this.field_70178_ae = this.blocklingType == BlocklingType.getTypeFromTextureName("blockling_9");
        if (this.blocklingType.textureName != "slimey_0" && this.field_70765_h instanceof SlimeMoveHelper) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
        } else if (this.blocklingType.textureName == "slimey_0" && !(this.field_70765_h instanceof SlimeMoveHelper)) {
            this.field_70765_h = new SlimeMoveHelper(this);
        }
        float prevHeight = this.field_70131_O;
        if (this.blocklingType.textureName == "chaosflo_0") {
            this.func_70105_a(0.7125f * this.scale - 0.1f, 0.7125f * this.scale + 0.35f);
        } else if (this.blocklingType.textureName == "slimey_0") {
            this.func_70105_a(0.7125f * this.scale - 0.15f, 0.7125f * this.scale - 0.23f);
        } else if (this.blocklingType.textureName == "melon_0") {
            this.func_70105_a(0.7125f * this.scale - 0.1f, 0.7125f * this.scale - 0.1f);
        } else {
            this.func_70105_a(0.7125f * this.scale, 0.7125f * this.scale);
        }
        this.func_98055_j(1.0f);
        double d0 = (double)this.field_70130_N / 2.0;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
        if (this.eatTimer >= 0) {
            --this.eatTimer;
        } else if (this.eatTimer == -1) {
            if (this.field_70170_p.field_72995_K) {
                this.eatUpgradeMaterial();
            }
            this.eatTimer = -2;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkTimers();
        }
        if (this.getAutoswitchLeft()) {
            this.switchTool(EnumHand.MAIN_HAND);
        }
        if (this.getAutoswitchRight()) {
            this.switchTool(EnumHand.OFF_HAND);
        }
        int n = this.combatAbilities.isAbilityAcquired(AbilityHelper.regen3) ? 4 : (this.combatAbilities.isAbilityAcquired(AbilityHelper.regen2) ? 2 : (regenLevel = this.combatAbilities.isAbilityAcquired(AbilityHelper.regen1) ? 1 : 0));
        if (regenLevel != 0) {
            if (this.regenTimer <= -1) {
                this.func_70691_i(regenLevel);
                this.regenTimer = 200;
            } else {
                --this.regenTimer;
            }
        } else {
            this.regenTimer = -1;
        }
        double d = this.generalAbilities.isAbilityAcquired(AbilityHelper.enderBoye2) ? 0.05 : (enderBoye = this.generalAbilities.isAbilityAcquired(AbilityHelper.enderBoye1) ? 0.02 : 0.0);
        if (enderBoye != 0.0 && this.func_70661_as().func_75505_d() != null && (double)this.field_70146_Z.nextFloat() <= enderBoye) {
            PathPoint finalPoint = this.func_70661_as().func_75505_d().func_75870_c();
            this.func_70012_b((double)finalPoint.field_75839_a + 0.5, finalPoint.field_75837_b, (double)finalPoint.field_75838_c + 0.5, this.field_70177_z, this.field_70125_A);
        }
        if (!this.field_70170_p.field_72995_K && this.farmingAbilities.isAbilityAcquired(AbilityHelper.natureAura)) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos blockPos = new BlockPos(this.field_70165_t + (double)x, this.field_70163_u + 0.5, this.field_70161_v + (double)z);
                    if (!(this.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof BlockCrops) || !(this.field_70146_Z.nextFloat() < 0.002f)) continue;
                    BlockCrops cropBlock = (BlockCrops)this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                    cropBlock.func_176474_b(this.field_70170_p, this.field_70146_Z, blockPos, this.field_70170_p.func_180495_p(blockPos));
                    this.field_70170_p.func_175718_b(2005, blockPos, 0);
                }
            }
        }
        this.checkAbilities();
        this.checkBonusStats();
        if (!this.field_70170_p.field_72995_K) {
            this.updateIsInAttackRange();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        boolean isMainHand = hand.equals((Object)EnumHand.MAIN_HAND);
        if (isMainHand) {
            if (!player.func_70093_af()) {
                if (!this.func_70909_n()) {
                    if (player != this.func_70902_q() && ItemHelper.isFlower(item)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 0.3f, 1.5f);
                            if (this.field_70146_Z.nextInt(3) == 0) {
                                this.setTamed(player);
                            } else {
                                this.func_70908_e(false);
                                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                            }
                        }
                    }
                } else if (player == this.func_70902_q()) {
                    if (ItemHelper.isFlower(item)) {
                        if (this.generalAbilities.isAbilityAcquired(AbilityHelper.botanist) && this.func_110143_aJ() < this.func_110138_aP()) {
                            if (!this.field_70170_p.field_72995_K) {
                                this.func_70691_i(this.field_70146_Z.nextInt(3) + 1);
                            }
                            if (!this.field_70170_p.field_72995_K) {
                                this.func_184185_a(SoundEvents.field_187537_bA, 0.3f, 1.5f);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                        }
                    } else if (ToolHelper.isTool(item)) {
                        this.setHeldItemFromInteract(stack, EnumHand.MAIN_HAND, player);
                    } else if (item == Items.field_151062_by) {
                        this.setCombatLevel(99);
                        this.setMiningLevel(99);
                        this.setWoodcuttingLevel(99);
                        this.setFarmingLevel(99);
                        this.setSkillPoints(99);
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.setState(this.state == EntityHelper.State.STAY ? EntityHelper.State.FOLLOW : EntityHelper.State.STAY);
                    } else {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, new SoundEvent(new ResourceLocation("block.lava.pop")), SoundCategory.AMBIENT, 50.0f, 100.0f, false);
                    }
                }
            } else if (this.func_70909_n() && player == this.func_70902_q()) {
                if (ItemHelper.isFlower(item)) {
                    if (this.generalAbilities.isAbilityAcquired(AbilityHelper.packling)) {
                        ItemStack blocklingStack;
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        if (!player.func_191521_c(blocklingStack = ItemBlockling.createStack(this, false))) {
                            this.func_70099_a(blocklingStack, 0.0f);
                        }
                        this.func_70106_y();
                    } else {
                        this.openGui(player);
                    }
                } else if (ToolHelper.isTool(item)) {
                    this.setHeldItemFromInteract(stack, EnumHand.OFF_HAND, player);
                } else {
                    this.openGui(player);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.field_70170_p.field_72995_K) {
                this.func_70908_e(true);
            }
            if (this.generalAbilities.isAbilityAcquired(AbilityHelper.flowerPower) && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack blocklingStack = ItemBlockling.createStack(this, !this.generalAbilities.isAbilityAcquired(AbilityHelper.armadillo));
            blocklingStack.func_77978_p().func_74776_a("Health", 1.0f);
            this.func_70099_a(blocklingStack, 0.0f);
        }
        super.func_70645_a(cause);
    }

    private void setHeldItemFromInteract(ItemStack stack, EnumHand hand, EntityPlayer player) {
        int index = hand == EnumHand.MAIN_HAND ? 1 : 2;
        ItemStack currentStack = this.inv.func_70301_a(index);
        if (!stack.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187719_p, 0.5f, 1.25f);
        }
        player.func_184611_a(EnumHand.MAIN_HAND, currentStack);
        this.setHeldItem(stack, hand);
    }

    public ItemStack func_184586_b(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184614_ca();
        }
        if (hand == EnumHand.OFF_HAND) {
            return this.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184592_cb() {
        return this.inv.func_70301_a(2);
    }

    public ItemStack func_184614_ca() {
        return this.inv.func_70301_a(1);
    }

    private void setHeldItem(ItemStack stack, EnumHand hand) {
        if (stack != null && !stack.func_190926_b()) {
            int index = hand == EnumHand.MAIN_HAND ? 1 : 2;
            this.inv.func_70299_a(index, stack);
        }
    }

    public void startEatingUpgradeMaterial(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            this.eatTimer = 20;
        }
    }

    private void eatUpgradeMaterial() {
        ItemStack itemStack = this.inv.func_70301_a(0);
        if (itemStack == ItemStack.field_190927_a || itemStack.func_77973_b() == Items.field_190931_a) {
            return;
        }
        BlocklingType blocklingType = BlocklingType.getTypeFromItemStack(itemStack);
        if (blocklingType == null || this.blocklingType == blocklingType) {
            return;
        }
        itemStack.func_190918_g(1);
        NetworkHelper.sync(this.field_70170_p, new InvItemStackMessage(itemStack, 0, this.func_145782_y()));
        if (this.field_70146_Z.nextFloat() < 0.5f) {
            this.blocklingType = blocklingType;
            this.playSoundEffect("block.anvil.use");
            NetworkHelper.sync(this.field_70170_p, new BlocklingTypeMessage(blocklingType, this.func_145782_y()));
        } else {
            this.playSoundEffect("block.anvil.hit");
        }
    }

    public void setBlocklingTypeFromPacketOnServer(BlocklingType type) {
        this.blocklingType = type;
        NetworkHelper.sync(this.field_70170_p, new BlocklingTypeMessage(this.blocklingType, this.func_145782_y()));
    }

    public void playSoundEffect(String sound) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, new SoundEvent(new ResourceLocation(sound)), SoundCategory.AMBIENT, 50.0f, 100.0f, false);
        }
    }

    public void damageItem(EnumHand hand) {
        this.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)this);
        if (this.func_184586_b(hand).func_190916_E() <= 0 || this.func_184586_b(hand) == ItemStack.field_190927_a || this.func_184586_b(hand).func_77952_i() > this.func_184586_b(hand).func_77958_k()) {
            NetworkHelper.sync(this.field_70170_p, new InvItemStackMessage(this.func_184586_b(hand), hand == EnumHand.MAIN_HAND ? 2 : 1, this.func_145782_y()));
        }
    }

    private boolean switchTool(EnumHand hand) {
        float bestValue = -1.0f;
        int slot = -1;
        int handSlot = hand == EnumHand.MAIN_HAND ? 1 : 2;
        ItemStack bestStack = this.func_184586_b(hand);
        boolean hasSwapped = false;
        if (this.isAttacking()) {
            bestValue = ToolHelper.getToolAttackPower(bestStack);
        } else if (this.task == EntityHelper.Task.MINE) {
            bestValue = ToolHelper.getPickaxeLevel(bestStack.func_77973_b());
        } else if (this.task == EntityHelper.Task.CHOP) {
            bestValue = ToolHelper.getAxeLevel(bestStack.func_77973_b());
        } else if (this.task == EntityHelper.Task.FARM) {
            bestValue = ToolHelper.getHoeLevel(bestStack.func_77973_b());
        } else if (this.isSetToAttack()) {
            bestValue = ToolHelper.getToolAttackPower(bestStack);
        }
        for (int i = 3; i < this.inv.func_70302_i_(); ++i) {
            float newValue;
            ItemStack invStack = this.inv.func_70301_a(i);
            if (this.isAttacking()) {
                newValue = ToolHelper.getToolAttackPower(invStack);
                if (!(newValue > bestValue)) continue;
                bestValue = newValue;
                bestStack = invStack;
                slot = i;
                continue;
            }
            if (this.task == EntityHelper.Task.MINE) {
                int newValue2 = ToolHelper.getPickaxeLevel(invStack.func_77973_b());
                if (!((float)newValue2 > bestValue)) continue;
                bestValue = newValue2;
                bestStack = invStack;
                slot = i;
                continue;
            }
            if (this.task == EntityHelper.Task.CHOP) {
                int newValue3 = ToolHelper.getAxeLevel(invStack.func_77973_b());
                if (!((float)newValue3 > bestValue)) continue;
                bestValue = newValue3;
                bestStack = invStack;
                slot = i;
                continue;
            }
            if (this.task == EntityHelper.Task.FARM) {
                int newValue4 = ToolHelper.getHoeLevel(invStack.func_77973_b());
                if (!((float)newValue4 > bestValue)) continue;
                bestValue = newValue4;
                bestStack = invStack;
                slot = i;
                continue;
            }
            if (!this.isSetToAttack() || !((newValue = ToolHelper.getToolAttackPower(invStack)) > bestValue)) continue;
            bestValue = newValue;
            bestStack = invStack;
            slot = i;
        }
        if (slot != -1) {
            ItemStack handStackCopy = this.func_184586_b(hand).func_77946_l();
            this.inv.func_70299_a(handSlot, bestStack);
            this.inv.func_70299_a(slot, handStackCopy);
            hasSwapped = true;
        }
        return hasSwapped;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        itemEntity.func_92058_a(this.inv.func_174894_a(stack));
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if (!this.generalAbilities.isAbilityAcquired(AbilityHelper.armadillo)) {
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                ItemStack stack = this.inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.func_70099_a(stack, 0.0f);
            }
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    private void checkAbilities() {
        this.setUnlockedSlots(this.generalAbilities.isAbilityAcquired(AbilityHelper.mule2) ? 36 : (this.generalAbilities.isAbilityAcquired(AbilityHelper.mule1) ? 24 : 12));
        if (this.generalAbilities.isAbilityAcquired(AbilityHelper.outline)) {
            this.func_70690_d(new PotionEffect(Potion.func_188412_a((int)24), 20, 0, false, false));
        }
    }

    public void openGui(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            if (this.guiID != GuiHelper.Tab.INVENTORY.id && this.guiID != GuiHelper.Tab.EQUIPMENT.id) {
                player.openGui((Object)Blocklings.instance, this.guiID, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
        } else if (this.guiID == GuiHelper.Tab.INVENTORY.id) {
            player.openGui((Object)Blocklings.instance, this.guiID, this.field_70170_p, this.func_145782_y(), 0, 0);
        } else if (this.guiID == GuiHelper.Tab.EQUIPMENT.id) {
            player.openGui((Object)Blocklings.instance, this.guiID, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public void openGui(int guiID, EntityPlayer player) {
        this.setGuiID(guiID);
        this.openGui(player);
        NetworkHelper.sync(this.field_70170_p, new OpenGuiMessage(this.func_145782_y()));
    }

    private void setTamed(EntityPlayer player) {
        this.func_193101_c(player);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.setState(EntityHelper.State.FOLLOW);
        this.func_70908_e(true);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.setName(!this.func_95999_t().equals("") ? this.func_95999_t() : "Blockling");
    }

    private void setupInventory() {
        InventoryBlockling invTemp = this.inv;
        this.inv = new InventoryBlockling(this, "Inventory", 39);
        this.inv.func_110133_a("Blockling Inventory");
        if (invTemp != null) {
            int slotsToCheck = Math.min(invTemp.func_70302_i_(), this.inv.func_70302_i_());
            for (int i = 0; i < slotsToCheck; ++i) {
                ItemStack stack = invTemp.func_70301_a(i);
                if (stack == null) continue;
                this.inv.func_70299_a(i, stack);
            }
        }
    }

    public void syncAbilities() {
        if (this.generalAbilities == null || this.combatAbilities == null || this.miningAbilities == null || this.woodcuttingAbilities == null || this.farmingAbilities == null) {
            return;
        }
        NetworkHelper.sync(this.field_70170_p, new AbilitiesMessage(this.generalAbilities, this.combatAbilities, this.miningAbilities, this.woodcuttingAbilities, this.farmingAbilities, this.func_145782_y()));
    }

    private void checkTimers() {
        if (this.isAttacking()) {
            this.setAnimationState(AnimationState.ATTACKING);
        } else if (this.isMining()) {
            this.setAnimationState(AnimationState.MINING);
        } else {
            this.setAnimationState(AnimationState.IDLE);
        }
        if (this.attackTimer >= 0) {
            this.incrementAttackTimer();
            if (this.attackTimer > this.attackInterval) {
                this.stopAttacking();
            }
        }
        if (this.miningTimer >= 0) {
            this.incrementMiningTimer();
            if (this.miningTimer > this.getCorrectInterval()) {
                this.stopMining();
            }
        }
    }

    private int getCorrectInterval() {
        if (this.task == EntityHelper.Task.MINE) {
            return this.miningInterval;
        }
        if (this.task == EntityHelper.Task.CHOP) {
            return this.choppingInterval;
        }
        if (this.task == EntityHelper.Task.FARM) {
            return this.farmingInterval;
        }
        return 40;
    }

    public void startAttacking() {
        this.setAttackTimer(0);
    }

    public void stopAttacking() {
        this.setAttackTimer(-1);
    }

    public boolean isAttacking() {
        return this.attackTimer != -1;
    }

    public void startMining() {
        this.setMiningTimer(0);
    }

    public void stopMining() {
        this.setMiningTimer(-1);
    }

    public boolean isMining() {
        return this.miningTimer != -1;
    }

    public boolean hasTool() {
        return this.hasTool(EnumHand.MAIN_HAND) || this.hasTool(EnumHand.OFF_HAND);
    }

    public boolean hasTool(EnumHand hand) {
        return ToolHelper.isTool(this.func_184586_b(hand).func_77973_b());
    }

    public boolean hasWeapon() {
        return this.hasWeapon(EnumHand.MAIN_HAND) || this.hasWeapon(EnumHand.OFF_HAND);
    }

    public boolean hasWeapon(EnumHand hand) {
        return ToolHelper.isWeapon(this.func_184586_b(hand).func_77973_b());
    }

    public boolean hasPickaxe() {
        return this.hasPickaxe(EnumHand.MAIN_HAND) || this.hasPickaxe(EnumHand.OFF_HAND);
    }

    public boolean hasPickaxe(EnumHand hand) {
        return ToolHelper.isPickaxe(this.func_184586_b(hand).func_77973_b());
    }

    public boolean hasHoe() {
        return this.hasHoe(EnumHand.MAIN_HAND) || this.hasHoe(EnumHand.OFF_HAND);
    }

    public boolean hasHoe(EnumHand hand) {
        return ToolHelper.isHoe(this.func_184586_b(hand).func_77973_b());
    }

    public boolean hasAxe() {
        return this.hasAxe(EnumHand.MAIN_HAND) || this.hasAxe(EnumHand.OFF_HAND);
    }

    public boolean hasAxe(EnumHand hand) {
        return ToolHelper.isAxe(this.func_184586_b(hand).func_77973_b());
    }

    public boolean isSetToAttack() {
        return this.task == EntityHelper.Task.HUNT || this.guard == EntityHelper.Guard.GUARD || this.func_70638_az() != null;
    }

    public boolean isUsingWeaponRight() {
        return this.hasWeapon(EnumHand.MAIN_HAND) && this.isSetToAttack();
    }

    public boolean isUsingWeaponLeft() {
        return this.hasWeapon(EnumHand.OFF_HAND) && this.isSetToAttack();
    }

    public boolean isUsingPickaxeRight() {
        return this.hasPickaxe(EnumHand.MAIN_HAND) && this.task == EntityHelper.Task.MINE;
    }

    public boolean isUsingPickaxeLeft() {
        return this.hasPickaxe(EnumHand.OFF_HAND) && this.task == EntityHelper.Task.MINE;
    }

    public boolean isUsingAxeRight() {
        return this.hasAxe(EnumHand.MAIN_HAND) && this.task == EntityHelper.Task.CHOP;
    }

    public boolean isUsingAxeLeft() {
        return this.hasAxe(EnumHand.OFF_HAND) && this.task == EntityHelper.Task.CHOP;
    }

    public boolean isUsingHoeRight() {
        return this.hasHoe(EnumHand.MAIN_HAND) && this.task == EntityHelper.Task.FARM;
    }

    public boolean isUsingHoeLeft() {
        return this.hasHoe(EnumHand.OFF_HAND) && this.task == EntityHelper.Task.FARM;
    }

    private void tryRemoveAttackTarget() {
        if (this.task != EntityHelper.Task.HUNT && this.guard != EntityHelper.Guard.GUARD) {
            this.func_70624_b(null);
        }
    }

    private void checkBonusStats() {
        boolean shouldCountOff;
        AttributeModifier typeBonusHealth = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a27"), "Type Bonus Health", this.blocklingType.bonusHealth, 0);
        AttributeModifier typeBonusAttackDamage = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a28"), "Type Bonus Attack Damage", this.blocklingType.bonusAttackDamage, 0);
        AttributeModifier typeBonusMovementSpeed = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a29"), "Type Bonus Movement Speed", this.blocklingType.bonusMovementSpeed / 40.0, 0);
        double weaponBonusAttackDamageValue = 0.0;
        double weaponBonusAttackSpeedValue = 0.0;
        boolean mainHandEmpty = this.func_184614_ca().func_190926_b();
        boolean offHandEmpty = this.func_184592_cb().func_190926_b();
        boolean bothTools = this.hasTool(EnumHand.MAIN_HAND) && this.hasTool(EnumHand.OFF_HAND) && !this.hasWeapon(EnumHand.MAIN_HAND) && !this.hasWeapon(EnumHand.OFF_HAND);
        boolean shouldCountMain = bothTools || this.hasWeapon(EnumHand.MAIN_HAND) || !this.hasWeapon(EnumHand.OFF_HAND);
        boolean bl = shouldCountOff = bothTools || this.hasWeapon(EnumHand.OFF_HAND) || !this.hasWeapon(EnumHand.MAIN_HAND);
        if (!mainHandEmpty && shouldCountMain) {
            weaponBonusAttackDamageValue += (double)ToolHelper.getToolAttackDamage(this.func_184614_ca());
            weaponBonusAttackSpeedValue += (double)ToolHelper.getToolAttackSpeed(this.func_184614_ca());
        }
        if (!offHandEmpty && shouldCountOff) {
            weaponBonusAttackDamageValue += (double)ToolHelper.getToolAttackDamage(this.func_184592_cb());
            weaponBonusAttackSpeedValue += (double)ToolHelper.getToolAttackSpeed(this.func_184592_cb());
        }
        if (shouldCountMain && shouldCountOff) {
            weaponBonusAttackDamageValue /= 2.0;
        }
        AttributeModifier weaponBonusAttackDamage = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a30"), "Weapon Bonus Attack Damage", weaponBonusAttackDamageValue, 0);
        AttributeModifier levelBonusHealth = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a31"), "Level Bonus Health", this.calcBonusHealthFromLevel(), 0);
        AttributeModifier levelBonusAttackDamage = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a32"), "Level Bonus Attack Damage", this.calcBonusDamageFromLevel(), 0);
        if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(typeBonusHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(typeBonusHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(typeBonusAttackDamage);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(typeBonusAttackDamage);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(typeBonusMovementSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(typeBonusMovementSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(weaponBonusAttackDamage);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(weaponBonusAttackDamage);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(levelBonusHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(levelBonusHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(levelBonusAttackDamage);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(levelBonusAttackDamage);
        }
        if (this.combatAbilities.isAbilityAcquired(AbilityHelper.berserker)) {
            float multiplier = 0.5f - this.func_110143_aJ() / this.func_110138_aP() / 2.0f;
            AttributeModifier damageMultiplier = new AttributeModifier(UUID.fromString("a6107045-134f-4c54-a645-75c3ae5c7a33"), "Damage Multiplier", (double)multiplier, 2);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(damageMultiplier);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(damageMultiplier);
        }
        if (weaponBonusAttackSpeedValue != 0.0) {
            this.setAttackInterval((int)(5.0 / weaponBonusAttackSpeedValue));
        } else {
            this.setAttackInterval(20);
        }
        if (this.hasPickaxe()) {
            this.setMiningInterval(this.calcBonusMiningSpeedFromLevel(this.miningLevel) - (this.miningAbilities.isAbilityAcquired(AbilityHelper.hasteMining) ? 10 : 0));
        } else {
            this.setMiningInterval(0);
        }
        if (this.hasAxe()) {
            this.setChoppingInterval(this.calcBonusMiningSpeedFromLevel(this.woodcuttingLevel) - (this.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.hasteWoodcutting) ? 10 : 0));
        } else {
            this.setChoppingInterval(0);
        }
        if (this.hasHoe()) {
            this.setFarmingInterval(this.calcBonusMiningSpeedFromLevel(this.farmingLevel) - (this.farmingAbilities.isAbilityAcquired(AbilityHelper.hasteFarming) ? 10 : 0));
        } else {
            this.setFarmingInterval(0);
        }
        if (!mainHandEmpty && !offHandEmpty) {
            if (this.hasPickaxe(EnumHand.MAIN_HAND) && this.hasPickaxe(EnumHand.OFF_HAND)) {
                this.setMiningInterval(this.miningInterval / 2);
            } else if (this.hasAxe(EnumHand.MAIN_HAND) && this.hasAxe(EnumHand.OFF_HAND)) {
                this.setChoppingInterval(this.choppingInterval / 2);
            } else if (this.hasHoe(EnumHand.MAIN_HAND) && this.hasHoe(EnumHand.OFF_HAND)) {
                this.setFarmingInterval(this.farmingInterval / 2);
            }
        }
    }

    private double calcBonusHealthFromLevel() {
        return 3.0 * Math.log(this.combatLevel);
    }

    private double calcBonusDamageFromLevel() {
        return 2.0 * Math.log(this.combatLevel);
    }

    private int calcBonusMiningSpeedFromLevel(int level) {
        return (int)(25.0 / Math.log((double)level / 30.0 + 1.5));
    }

    private void onXpGained() {
        if (this.combatXp >= EntityHelper.getXpUntilNextLevel(this.combatLevel)) {
            this.setCombatXp(0);
            this.setCombatLevel(this.combatLevel + 1);
            if (this.combatLevel % 5 == 0) {
                this.incrementSkillPoints(1);
                this.sendSkillPointMessage();
            }
        } else if (this.miningXp >= EntityHelper.getXpUntilNextLevel(this.miningLevel)) {
            this.setMiningXp(0);
            this.setMiningLevel(this.miningLevel + 1);
            if (this.miningLevel % 5 == 0) {
                this.incrementSkillPoints(1);
                this.sendSkillPointMessage();
            }
        } else if (this.woodcuttingXp >= EntityHelper.getXpUntilNextLevel(this.woodcuttingLevel)) {
            this.setWoodcuttingXp(0);
            this.setWoodcuttingLevel(this.woodcuttingLevel + 1);
            if (this.woodcuttingLevel % 5 == 0) {
                this.incrementSkillPoints(1);
                this.sendSkillPointMessage();
            }
        } else if (this.farmingXp >= EntityHelper.getXpUntilNextLevel(this.farmingLevel)) {
            this.setFarmingXp(0);
            this.setFarmingLevel(this.farmingLevel + 1);
            if (this.farmingLevel % 5 == 0) {
                this.incrementSkillPoints(1);
                this.sendSkillPointMessage();
            }
        }
    }

    private void sendSkillPointMessage() {
        if (this.func_70902_q() != null) {
            EntityPlayer player = (EntityPlayer)this.func_70902_q();
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.GOLD + this.func_95999_t() + ChatFormatting.WHITE + " gained a skill point!"));
            }
        }
    }

    public EntityHelper.Task getTask() {
        return this.task;
    }

    public void setTask(EntityHelper.Task value) {
        this.task = value;
        NetworkHelper.sync(this.field_70170_p, new TaskIDMessage(value.id, this.func_145782_y()));
        this.tryRemoveAttackTarget();
        this.updateAI();
    }

    public void setTaskFromPacket(int value) {
        this.task = EntityHelper.Task.getFromID(value);
        this.updateAI();
    }

    public void cycleTask() {
        int id = this.task.id + 1;
        if (id > EntityHelper.Task.values().length) {
            id = 1;
        }
        this.task = EntityHelper.Task.getFromID(id);
    }

    public EntityHelper.Guard getGuard() {
        return this.guard;
    }

    public void setGuard(EntityHelper.Guard value) {
        this.guard = value;
        NetworkHelper.sync(this.field_70170_p, new GuardIDMessage(value.id, this.func_145782_y()));
        this.tryRemoveAttackTarget();
        this.updateAI();
    }

    public void setGuardFromPacket(int value) {
        this.guard = EntityHelper.Guard.getFromID(value);
        this.updateAI();
    }

    public void cycleGuard() {
        int id = this.guard.id + 1;
        if (id > EntityHelper.Guard.values().length) {
            id = 1;
        }
        this.setGuard(EntityHelper.Guard.getFromID(id));
    }

    public EntityHelper.State getState() {
        return this.state;
    }

    public void setState(EntityHelper.State value) {
        this.state = value;
        NetworkHelper.sync(this.field_70170_p, new StateIDMessage(value.id, this.func_145782_y()));
        this.updateAI();
    }

    public void setStateFromPacket(int value) {
        this.state = EntityHelper.State.getFromID(value);
        this.updateAI();
    }

    public void cycleState() {
        int id = this.state.id + 1;
        if (id > EntityHelper.State.values().length) {
            id = 1;
        }
        this.setState(EntityHelper.State.getFromID(id));
    }

    public int getUnlockedSlots() {
        return this.unlockedSlots;
    }

    public void setUnlockedSlots(int value) {
        this.unlockedSlots = value;
        NetworkHelper.sync(this.field_70170_p, new UnlockedSlotsMessage(value, this.func_145782_y()));
    }

    public void setUnlockedSlotsFromPacket(int value) {
        this.unlockedSlots = value;
    }

    public float getBlocklingScale() {
        return this.scale;
    }

    public void setBlocklingScale(float value) {
        this.scale = value;
        NetworkHelper.sync(this.field_70170_p, new ScaleMessage(value, this.func_145782_y()));
    }

    public void setScaleFromPacket(float value) {
        this.scale = value;
    }

    @SideOnly(value=Side.CLIENT)
    public void setName(String value) {
        if (value == null || value.equals("")) {
            this.func_96094_a("Blockling");
        } else {
            this.func_96094_a(value);
        }
        NetworkHelper.sync(this.field_70170_p, new NameMessage(this.func_95999_t(), this.func_145782_y()));
    }

    public void setNameFromPacket(String value) {
        this.func_96094_a(value);
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public void setAnimationState(AnimationState value) {
        this.animationState = value;
        NetworkHelper.sync(this.field_70170_p, new AnimationStateMessage(value, this.func_145782_y()));
    }

    public void setAnimationStateFromPacket(AnimationState value) {
        this.animationState = value;
    }

    public int getGuiID() {
        return this.guiID;
    }

    public void setGuiID(int value) {
        this.guiID = value;
        NetworkHelper.sync(this.field_70170_p, new GuiIDMessage(value, this.func_145782_y()));
    }

    public void setGuiIDFromPacket(int value) {
        this.guiID = value;
    }

    public EnumHand getAttackingHand() {
        return this.attackingHand;
    }

    public void setAttackingHand(EnumHand value) {
        this.attackingHand = value;
        NetworkHelper.sync(this.field_70170_p, new AttackingHandMessage(value, this.func_145782_y()));
    }

    public void setAttackingHandFromPacket(EnumHand value) {
        this.attackingHand = value;
    }

    public int getAttackInterval() {
        return this.attackInterval;
    }

    public void setAttackInterval(int value) {
        this.attackInterval = value;
        NetworkHelper.sync(this.field_70170_p, new AttackIntervalMessage(value, this.func_145782_y()));
    }

    public void setAttackIntervalFromPacket(int value) {
        this.attackInterval = value;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void incrementAttackTimer() {
        this.setAttackTimer(this.attackTimer + 1);
    }

    public void setAttackTimer(int value) {
        this.attackTimer = value;
        if (!this.field_70170_p.field_72995_K) {
            NetworkHelper.sync(this.field_70170_p, new AttackTimerMessage(value, this.func_145782_y()));
        }
    }

    public void setAttackTimerFromPacket(int value) {
        this.attackTimer = value;
    }

    public int getMiningInterval() {
        return this.miningInterval;
    }

    public void setMiningInterval(int value) {
        this.miningInterval = value;
        if (!this.field_70170_p.field_72995_K) {
            NetworkHelper.sync(this.field_70170_p, new MiningIntervalMessage(value, this.func_145782_y()));
        }
    }

    public void setMiningIntervalFromPacket(int value) {
        this.miningInterval = value;
    }

    public int getChoppingInterval() {
        return this.choppingInterval;
    }

    public void setChoppingInterval(int value) {
        this.choppingInterval = value;
        if (!this.field_70170_p.field_72995_K) {
            NetworkHelper.sync(this.field_70170_p, new ChoppingIntervalMessage(value, this.func_145782_y()));
        }
    }

    public void setChoppingIntervalFromPacket(int value) {
        this.choppingInterval = value;
    }

    public int getFarmingInterval() {
        return this.farmingInterval;
    }

    public void setFarmingInterval(int value) {
        this.farmingInterval = value;
        if (!this.field_70170_p.field_72995_K) {
            NetworkHelper.sync(this.field_70170_p, new FarmingIntervalMessage(value, this.func_145782_y()));
        }
    }

    public void setFarmingIntervalFromPacket(int value) {
        this.farmingInterval = value;
    }

    public int getMiningTimer() {
        return this.miningTimer;
    }

    public void incrementMiningTimer() {
        this.setMiningTimer(this.miningTimer + 1);
    }

    public void setMiningTimer(int value) {
        this.miningTimer = value;
        NetworkHelper.sync(this.field_70170_p, new MiningTimerMessage(value, this.func_145782_y()));
    }

    public void setMiningTimerFromPacket(int value) {
        this.miningTimer = value;
    }

    public boolean hasTarget() {
        return this.aiMining.hasTarget() || this.aiWoodcutting.hasTarget() || this.aiFarming.hasTarget();
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void incrementSkillPoints(int value) {
        this.setSkillPoints(this.skillPoints + value);
    }

    public void setSkillPoints(int value) {
        this.skillPoints = value;
        NetworkHelper.sync(this.field_70170_p, new SkillPointsMessage(value, this.func_145782_y()));
    }

    public void setSkillPointsFromPacket(int value) {
        this.skillPoints = value;
    }

    public int getLevel(String levelName) {
        switch (levelName) {
            case "Combat": {
                return this.combatLevel;
            }
            case "Mining": {
                return this.miningLevel;
            }
            case "Woodcutting": {
                return this.woodcuttingLevel;
            }
            case "Farming": {
                return this.farmingLevel;
            }
        }
        return 0;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public void setCombatLevel(int value) {
        this.combatLevel = value;
        if (this.combatLevel > 99) {
            this.combatLevel = 99;
        }
        NetworkHelper.sync(this.field_70170_p, new CombatLevelMessage(value, this.func_145782_y()));
    }

    public void setCombatLevelFromPacket(int value) {
        this.combatLevel = value;
    }

    public int getMiningLevel() {
        return this.miningLevel;
    }

    public void setMiningLevel(int value) {
        this.miningLevel = value;
        if (this.miningLevel > 99) {
            this.miningLevel = 99;
        }
        NetworkHelper.sync(this.field_70170_p, new MiningLevelMessage(value, this.func_145782_y()));
    }

    public void setMiningLevelFromPacket(int value) {
        this.miningLevel = value;
    }

    public int getWoodcuttingLevel() {
        return this.woodcuttingLevel;
    }

    public void setWoodcuttingLevel(int value) {
        this.woodcuttingLevel = value;
        if (this.woodcuttingLevel > 99) {
            this.woodcuttingLevel = 99;
        }
        NetworkHelper.sync(this.field_70170_p, new WoodcuttingLevelMessage(value, this.func_145782_y()));
    }

    public void setWoodcuttingLevelFromPacket(int value) {
        this.woodcuttingLevel = value;
    }

    public int getFarmingLevel() {
        return this.farmingLevel;
    }

    public void setFarmingLevel(int value) {
        this.farmingLevel = value;
        if (this.farmingLevel > 99) {
            this.farmingLevel = 99;
        }
        NetworkHelper.sync(this.field_70170_p, new FarmingLevelMessage(value, this.func_145782_y()));
    }

    public void setFarmingLevelFromPacket(int value) {
        this.farmingLevel = value;
    }

    public int getCombatXp() {
        return this.combatXp;
    }

    public void incrementCombatXp(int value) {
        this.setCombatXp(this.combatXp + value);
    }

    public void setCombatXp(int value) {
        this.combatXp = value;
        NetworkHelper.sync(this.field_70170_p, new CombatXpMessage(value, this.func_145782_y()));
        this.onXpGained();
    }

    public void setCombatXpFromPacket(int value) {
        this.combatXp = value;
        this.onXpGained();
    }

    public int getMiningXp() {
        return this.miningXp;
    }

    public void incrementMiningXp(int value) {
        this.setMiningXp(this.miningXp + value);
    }

    public void setMiningXp(int value) {
        this.miningXp = value;
        NetworkHelper.sync(this.field_70170_p, new MiningXpMessage(value, this.func_145782_y()));
        this.onXpGained();
    }

    public void setMiningXpFromPacket(int value) {
        this.miningXp = value;
        this.onXpGained();
    }

    public int getWoodcuttingXp() {
        return this.woodcuttingXp;
    }

    public void incrementWoodcuttingXp(int value) {
        this.setWoodcuttingXp(this.woodcuttingXp + value);
    }

    public void setWoodcuttingXp(int value) {
        this.woodcuttingXp = value;
        NetworkHelper.sync(this.field_70170_p, new WoodcuttingXpMessage(value, this.func_145782_y()));
        this.onXpGained();
    }

    public void setWoodcuttingXpFromPacket(int value) {
        this.woodcuttingXp = value;
        this.onXpGained();
    }

    public int getFarmingXp() {
        return this.farmingXp;
    }

    public void incrementFarmingXp(int value) {
        this.setFarmingXp(this.farmingXp + value);
    }

    public void setFarmingXp(int value) {
        this.farmingXp = value;
        NetworkHelper.sync(this.field_70170_p, new FarmingXpMessage(value, this.func_145782_y()));
        this.onXpGained();
    }

    public void setFarmingXpFromPacket(int value) {
        this.farmingXp = value;
        this.onXpGained();
    }

    public boolean getAutoswitchLeft() {
        return (this.autoswitchID & 2) > 0;
    }

    public boolean getAutoswitchRight() {
        return (this.autoswitchID & 1) > 0;
    }

    public void setAutoswitchLeft(boolean on) {
        byte result = this.autoswitchID;
        result = on ? (byte)(this.autoswitchID | 2) : (byte)(this.autoswitchID & 1);
        this.setAutoswitchID(result);
    }

    public void setAutoswitchRight(boolean on) {
        byte result = this.autoswitchID;
        result = on ? (byte)(this.autoswitchID | 1) : (byte)(this.autoswitchID & 2);
        this.setAutoswitchID(result);
    }

    private void setAutoswitchID(byte value) {
        this.autoswitchID = value;
        NetworkHelper.sync(this.field_70170_p, new AutoswitchIDMessage(value, this.func_145782_y()));
    }

    public void setAutoswitchIDFromPacket(byte value) {
        this.autoswitchID = value;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(10);
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityBlockling slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntityBlockling slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.field_75648_a.field_70759_as;
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        this.slime.func_184185_a(SoundEvents.field_187882_fq, 1.0f, 2.0f);
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    public static enum AnimationState {
        IDLE,
        ATTACKING,
        MINING;

    }
}

