/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkCacheBlockling
implements IBlockAccess {
    protected int chunkX;
    protected int chunkZ;
    protected Chunk[][] chunkArray;
    protected boolean empty;
    protected World world;
    private BlockPos removedPos;

    public ChunkCacheBlockling(World worldIn, BlockPos posFromIn, BlockPos posToIn, BlockPos removedPos, int subIn) {
        this.world = worldIn;
        this.removedPos = removedPos;
        this.chunkX = posFromIn.func_177958_n() - subIn >> 4;
        this.chunkZ = posFromIn.func_177952_p() - subIn >> 4;
        int i = posToIn.func_177958_n() + subIn >> 4;
        int j = posToIn.func_177952_p() + subIn >> 4;
        this.chunkArray = new Chunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.empty = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = worldIn.func_72964_e(k, l);
            }
        }
        for (int i1 = posFromIn.func_177958_n() >> 4; i1 <= posToIn.func_177958_n() >> 4; ++i1) {
            for (int j1 = posFromIn.func_177952_p() >> 4; j1 <= posToIn.func_177952_p() >> 4; ++j1) {
                Chunk chunk = this.chunkArray[i1 - this.chunkX][j1 - this.chunkZ];
                if (chunk == null || chunk.func_76606_c(posFromIn.func_177956_o(), posToIn.func_177956_o())) continue;
                this.empty = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEmpty() {
        return this.empty;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.EnumCreateEntityType p_190300_2_) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.chunkZ)) {
            return null;
        }
        return this.chunkArray[i][j].func_177424_a(pos, p_190300_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        int i = this.getLightForExt(EnumSkyBlock.SKY, pos);
        int j = this.getLightForExt(EnumSkyBlock.BLOCK, pos);
        if (j < lightValue) {
            j = lightValue;
        }
        return i << 20 | j << 4;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (!pos.equals((Object)this.removedPos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            int j = (pos.func_177952_p() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_177435_g(pos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public Biome func_180494_b(BlockPos pos) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.chunkZ)) {
            return Biomes.field_76772_c;
        }
        return this.chunkArray[i][j].func_177411_a(pos, this.world.func_72959_q());
    }

    @SideOnly(value=Side.CLIENT)
    private int getLightForExt(EnumSkyBlock type, BlockPos pos) {
        if (type == EnumSkyBlock.SKY && !this.world.field_73011_w.func_191066_m()) {
            return 0;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            int j;
            if (this.func_180495_p(pos).func_185916_f()) {
                int l = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int k = this.getLightFor(type, pos.func_177972_a(enumfacing));
                    if (k > l) {
                        l = k;
                    }
                    if (l < 15) continue;
                    return l;
                }
                return l;
            }
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.chunkZ)) {
                return type.field_77198_c;
            }
            return this.chunkArray[i][j].func_177413_a(type, pos);
        }
        return type.field_77198_c;
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightFor(EnumSkyBlock type, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            int j;
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.chunkZ)) {
                return type.field_77198_c;
            }
            return this.chunkArray[i][j].func_177413_a(type, pos);
        }
        return type.field_77198_c;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockAccess)this, pos, direction);
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int x = (pos.func_177958_n() >> 4) - this.chunkX;
        int z = (pos.func_177952_p() >> 4) - this.chunkZ;
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return _default;
        }
        if (!this.withinBounds(x, z)) {
            return _default;
        }
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isSideSolid(state, (IBlockAccess)this, pos, side);
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }
}

