/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.abilities.AbilityHelper;
import com.blocklings.entities.BlocklingAIGatherBase;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.util.helpers.BlockHelper;
import com.blocklings.util.helpers.DropHelper;
import com.blocklings.util.helpers.EntityHelper;
import com.blocklings.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BlocklingAIWoodcutting
extends BlocklingAIGatherBase {
    private static final int X_RADIUS = 10;
    private static final int Y_RADIUS = 10;
    private int treeSearchCount = 0;
    private int leafCount = 0;
    private List<BlockPos> tree = new ArrayList<BlockPos>();
    private List<BlockPos> logsToCheck = new ArrayList<BlockPos>();
    private int badLogResetCount = 0;
    private List<BlockPos> logsThatAreNotTrees = new ArrayList<BlockPos>();

    public BlocklingAIWoodcutting(EntityBlockling blockling) {
        super(blockling);
    }

    public void func_75251_c() {
        this.blockling.stopMining();
        if (this.tree != null && !this.tree.isEmpty()) {
            this.world.func_175715_c(this.blockling.func_145782_y(), this.tree.get(this.tree.size() - 1), -1);
        }
        this.resetTarget();
        super.func_75251_c();
    }

    @Override
    public boolean func_75250_a() {
        if (!this.canExecute()) {
            return false;
        }
        ++this.badLogResetCount;
        if (this.badLogResetCount > 100) {
            this.logsThatAreNotTrees.clear();
            this.badLogResetCount = 0;
        }
        boolean foundLog = false;
        this.resetTarget();
        this.targetPathSquareDistance = 10000.0;
        int x = (int)this.blockling.field_70165_t - 10;
        while ((double)x < this.blockling.field_70165_t + 10.0) {
            int y = (int)this.blockling.field_70163_u - 10;
            while ((double)y < this.blockling.field_70163_u + 10.0) {
                int z = (int)this.blockling.field_70161_v - 10;
                while ((double)z < this.blockling.field_70161_v + 10.0) {
                    Block block = this.getBlockAt(x, y, z);
                    if (BlockHelper.isLog(block)) {
                        BlockPos blockPos = new BlockPos(x, y, z);
                        Vec3d blockVec = this.getVecFromBlockPos(blockPos);
                        Block belowBlock = this.getBlockAt(x, y - 1, z);
                        if (BlockHelper.isDirt(belowBlock) && !this.logsThatAreNotTrees.contains(blockPos)) {
                            double pathSquareDistance;
                            Path pathToBlock;
                            if (this.blockling.func_174791_d().func_72438_d(blockVec) < (double)this.range) {
                                this.targetPathSquareDistance = 1.0;
                                this.setTarget(blockPos);
                                foundLog = true;
                            }
                            if ((pathToBlock = this.getSafishPathTo(blockPos)) != null && this.isPathDestInRange(pathToBlock, blockPos) && (pathSquareDistance = this.getPathSquareDistance(pathToBlock)) < this.targetPathSquareDistance) {
                                this.targetPathSquareDistance = pathSquareDistance;
                                this.setTarget(blockPos, pathToBlock);
                                foundLog = true;
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return foundLog;
    }

    public boolean func_75253_b() {
        return this.canContinueExecuting();
    }

    @Override
    boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (this.blockling.getTask() != EntityHelper.Task.CHOP) {
            return false;
        }
        return this.blockling.hasAxe();
    }

    @Override
    boolean canContinueExecuting() {
        return super.canContinueExecuting();
    }

    public void func_75246_d() {
        if (this.hasTarget() && this.findTree()) {
            if (this.isTree()) {
                if (this.isBlocklingInRange(this.targetPos)) {
                    if (this.tryChopTarget() && this.tree.isEmpty()) {
                        this.resetTarget();
                    }
                } else if (!this.moveToTarget()) {
                    this.resetTarget();
                }
            } else {
                this.logsThatAreNotTrees.addAll(this.tree);
                this.resetTarget();
            }
        }
    }

    private boolean tryChopTarget() {
        this.blockling.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 1000.0f, 100.0f);
        if (!this.blockling.isMining()) {
            this.blockling.startMining();
        }
        BlockPos logPos = this.tree.get(this.tree.size() - 1);
        if (this.blockling.getMiningTimer() >= this.blockling.getChoppingInterval()) {
            if (this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.sawmill) && this.rand.nextFloat() < 0.1f && this.tree.size() > 1) {
                this.chopLog(this.tree.size() - 2);
            }
            this.chopLog();
            this.blockling.stopMining();
            this.world.func_175715_c(this.blockling.func_145782_y(), logPos, -1);
            return true;
        }
        int progress = (int)((float)this.blockling.getMiningTimer() / (float)this.blockling.getChoppingInterval() * 9.0f);
        this.world.func_175715_c(this.blockling.func_145782_y(), logPos, progress);
        return false;
    }

    private void chopLog() {
        this.chopLog(this.tree.size() - 1);
    }

    private void chopLog(int pos) {
        ItemStack sapling;
        BlockPos logPos = this.tree.get(pos);
        if (this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.leafBlower)) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int k = -1; k < 2; ++k) {
                        BlockPos surroundingPos;
                        Block surroundingBlock;
                        if (i == 0 && j == 0 && k == 0 || !BlockHelper.isLeaf(surroundingBlock = this.getBlockFromPos(surroundingPos = new BlockPos(logPos.func_177958_n() + i, logPos.func_177956_o() + j, logPos.func_177952_p() + k)))) continue;
                        if (this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.treeSurgeon)) {
                            NonNullList<ItemStack> dropStacks = DropHelper.getDops(this.blockling, this.world, surroundingPos);
                            for (ItemStack dropStack : dropStacks) {
                                ItemStack leftoverStack = this.blockling.inv.func_174894_a(dropStack);
                                if (leftoverStack.func_190926_b()) continue;
                                this.blockling.func_70099_a(leftoverStack, 0.0f);
                            }
                        }
                        this.world.func_175698_g(surroundingPos);
                    }
                }
            }
        }
        NonNullList<ItemStack> dropStacks = DropHelper.getDops(this.blockling, this.world, logPos);
        for (ItemStack dropStack : dropStacks) {
            ItemStack leftoverStack;
            if (this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.forestFire)) {
                dropStack = new ItemStack(Items.field_151044_h, dropStack.func_190916_E(), 1);
            }
            if ((leftoverStack = this.blockling.inv.func_174894_a(dropStack)).func_190926_b()) continue;
            this.blockling.func_70099_a(leftoverStack, 0.0f);
        }
        if (this.blockling.isUsingAxeRight()) {
            this.blockling.damageItem(EnumHand.MAIN_HAND);
        }
        if (this.blockling.isUsingAxeLeft()) {
            this.blockling.damageItem(EnumHand.OFF_HAND);
        }
        if ((sapling = ItemHelper.getSaplingForLog(this.world.func_180495_p(this.targetPos))) != null && pos == 0 && this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.treeHugger) && this.blockling.inv.takeStackFromInventory(sapling)) {
            this.world.func_175656_a(this.targetPos, Blocks.field_150345_g.func_176203_a(sapling.func_77960_j()));
            if (this.blockling.woodcuttingAbilities.isAbilityAcquired(AbilityHelper.fertilisationWoodcutting) && this.blockling.inv.takeStackFromInventory(new ItemStack(Items.field_151100_aR, 1, 15))) {
                BlockSapling saplingBlock = (BlockSapling)this.getBlockFromPos(this.targetPos);
                saplingBlock.func_176478_d(this.world, this.targetPos, this.world.func_180495_p(this.targetPos), this.rand);
                this.world.func_175718_b(2005, this.targetPos, 0);
            }
        } else {
            this.world.func_175698_g(logPos);
        }
        this.blockling.incrementWoodcuttingXp(this.rand.nextInt(5) + 3);
        this.tree.remove(logPos);
    }

    private boolean isTree() {
        return this.leafCount > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findTree() {
        if (this.logsToCheck.isEmpty()) {
            if (!this.tree.isEmpty()) return true;
            this.treeSearchCount = 0;
            this.leafCount = 0;
            this.logsToCheck.add(this.targetPos);
            this.tree.add(this.targetPos);
        } else {
            if (this.treeSearchCount > 150) {
                return true;
            }
            int localCount = 0;
            while (localCount < 2) {
                BlockPos testLog = this.logsToCheck.get(0);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            if (i == 0 && j == 0 && k == 0) continue;
                            BlockPos surroundingPos = new BlockPos(testLog.func_177958_n() + i, testLog.func_177956_o() + j, testLog.func_177952_p() + k);
                            Block surroundingBlock = this.getBlockFromPos(surroundingPos);
                            if (BlockHelper.isLog(surroundingBlock)) {
                                if (!this.tree.contains(surroundingPos)) {
                                    this.tree.add(surroundingPos);
                                    this.logsToCheck.add(surroundingPos);
                                }
                            } else if (BlockHelper.isLeaf(surroundingBlock)) {
                                ++this.leafCount;
                            }
                            ++localCount;
                        }
                    }
                }
                this.logsToCheck.remove(0);
            }
        }
        ++this.treeSearchCount;
        return false;
    }

    @Override
    void resetTarget() {
        super.resetTarget();
        this.tree.clear();
        this.logsToCheck.clear();
    }

    private void setTargetToRandom() {
        if (this.getBlockFromPos(this.targetPos) != Blocks.field_150364_r) {
            this.world.func_175656_a(this.targetPos, Blocks.field_150364_r.func_176223_P());
        } else {
            this.world.func_175656_a(this.targetPos, Blocks.field_150363_s.func_176223_P());
        }
    }
}

