/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.entities.EntityBlockling;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;

public class BlocklingAIWander
extends EntityAIBase {
    protected final EntityCreature entity;
    protected double x;
    protected double y;
    protected double z;
    protected int executionChance;
    protected boolean mustUpdate;
    private EntityBlockling blockling;

    public BlocklingAIWander(EntityCreature creatureIn) {
        this(creatureIn, 120);
    }

    public BlocklingAIWander(EntityCreature creatureIn, int chance) {
        this.entity = creatureIn;
        this.blockling = (EntityBlockling)creatureIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.blockling.hasTarget()) {
            return false;
        }
        if (!this.mustUpdate && this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        return RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)10, (int)7);
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() || this.blockling.blocklingType.textureName == "slimey_0";
    }

    public void func_75249_e() {
        if (this.blockling.blocklingType.textureName != "slimey_0") {
            this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        } else {
            this.blockling.func_70671_ap().func_75650_a(this.x, this.y, this.z, 30.0f, 30.0f);
            ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setSpeed(1.0);
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

