/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.entities.PathNavigateGroundBlockling;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlocklingAIGatherBase
extends EntityAIBase {
    Random rand = new Random();
    EntityBlockling blockling;
    World world;
    Block targetBlock;
    BlockPos targetPos;
    Vec3d targetVec;
    Path targetPath;
    double targetPathSquareDistance;
    float range = 2.5f;

    BlocklingAIGatherBase(EntityBlockling blockling) {
        this.blockling = blockling;
        this.world = blockling.field_70170_p;
    }

    boolean canExecute() {
        return !this.blockling.func_70906_o() && this.blockling.func_70638_az() == null;
    }

    boolean canContinueExecuting() {
        return this.canExecute() && this.hasTarget() && this.world.func_180495_p(this.targetPos).func_177230_c() != Blocks.field_150350_a;
    }

    public boolean func_75250_a() {
        return false;
    }

    double getPathSquareDistance(Path path) {
        if (path == null) {
            return 100000.0;
        }
        double distance = 0.0;
        Vec3d prevVec = null;
        for (int i = 0; i < path.func_75874_d(); ++i) {
            PathPoint nextPoint = path.func_75877_a(i);
            Vec3d nextVec = new Vec3d((double)nextPoint.field_75839_a, (double)nextPoint.field_75837_b, (double)nextPoint.field_75838_c);
            if (prevVec != null) {
                distance += prevVec.func_72436_e(nextVec);
            }
            prevVec = nextVec;
        }
        return distance;
    }

    Block getBlockAt(int x, int y, int z) {
        return this.blockling.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    boolean moveToTarget() {
        if (this.targetPath != null) {
            if (this.blockling.blocklingType.textureName != "slimey_0") {
                PathPoint finalPoint = this.targetPath.func_75870_c();
                this.blockling.func_70661_as().func_75492_a((double)finalPoint.field_75839_a + 0.5, (double)finalPoint.field_75837_b, (double)finalPoint.field_75838_c + 0.5, this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                return this.blockling.func_70661_as().func_75505_d() != null;
            }
            if (this.targetPos != null) {
                this.blockling.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), 90.0f, 0.0f);
            }
            ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setSpeed(1.0);
            return false;
        }
        return false;
    }

    boolean isPosInRange(BlockPos blockPos, BlockPos blockPosTarget) {
        Vec3d blockVecTarget;
        Vec3d blockVec = this.getVecFromBlockPos(blockPos);
        return blockVec.func_72438_d(blockVecTarget = this.getVecFromBlockPos(blockPosTarget)) < (double)this.range;
    }

    boolean isPathDestInRange(Path path, BlockPos blockPos) {
        if (path != null) {
            PathPoint finalPoint = path.func_75870_c();
            Vec3d finalVec = this.getVecFromPathPoint(finalPoint);
            Vec3d blockVec = this.getVecFromBlockPos(blockPos);
            return blockVec.func_72438_d(finalVec) < (double)this.range;
        }
        return false;
    }

    boolean isBlocklingInRange(BlockPos blockPos) {
        Vec3d blockVec;
        Vec3d blocklingVec = this.getVecFromBlockPos(this.blockling.func_180425_c());
        return blocklingVec.func_72438_d(blockVec = this.getVecFromBlockPos(blockPos)) < (double)this.range;
    }

    Path getSafishPathTo(BlockPos blockPos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos surroundingPos = new BlockPos(blockPos.func_177958_n() + i, blockPos.func_177956_o() + j, blockPos.func_177952_p() + k);
                    Path testPath = this.blockling.func_70661_as().func_179680_a(surroundingPos);
                    if (testPath == null) continue;
                    PathPoint finalPoint = testPath.func_75870_c();
                    BlockPos finalPos = this.getPosFromPathPoint(finalPoint);
                    if (!this.isPathDestInRange(testPath, blockPos) || finalPos.equals((Object)blockPos)) continue;
                    return testPath;
                }
            }
        }
        return this.blockling.func_70661_as().func_179680_a(blockPos);
    }

    Path getSafishPathToWithRemovedBlock(BlockPos blockPos, BlockPos removedPos) {
        return ((PathNavigateGroundBlockling)this.blockling.func_70661_as()).getPathToPosWithRemovedBlock(blockPos, removedPos);
    }

    Vec3d getVecFromBlockPos(BlockPos blockPos) {
        return new Vec3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
    }

    Vec3d getVecFromPathPoint(PathPoint pathPoint) {
        return new Vec3d((double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.5, (double)pathPoint.field_75838_c + 0.5);
    }

    BlockPos getPosFromPathPoint(PathPoint pathPoint) {
        return new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
    }

    Block getBlockFromPos(BlockPos blockPos) {
        return this.world.func_180495_p(blockPos).func_177230_c();
    }

    boolean canSeeBlock(int x, int y, int z) {
        return this.canSeeBlock(new Vec3d((double)x, (double)y, (double)z));
    }

    boolean canSeeBlock(Vec3d blockVec) {
        double height = 0.6f * this.blockling.getBlocklingScale();
        for (int it = 0; it < 2; ++it) {
            double xStart = this.blockling.field_70165_t;
            double yStart = it == 0 ? this.blockling.field_70163_u + height * 0.2 : this.blockling.field_70163_u + height * 0.8;
            double zStart = this.blockling.field_70161_v;
            Vec3d blocklingVec = new Vec3d(xStart, yStart, zStart);
            for (double i = 0.03; i <= 0.97; i += 0.94) {
                for (double j = 0.03; j <= 0.97; j += 0.94) {
                    for (double k = 0.03; k <= 0.97; k += 0.94) {
                        BlockPos pos;
                        Vec3d testVec = new Vec3d(Math.floor(blockVec.field_72450_a) + i, Math.floor(blockVec.field_72448_b) + j, Math.floor(blockVec.field_72449_c) + k);
                        RayTraceResult result = this.blockling.field_70170_p.func_147447_a(blocklingVec, testVec, true, true, true);
                        if (result == null || !(pos = result.func_178782_a()).equals((Object)new BlockPos(blockVec))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    void resetTarget() {
        this.targetBlock = null;
        this.targetPos = null;
        this.targetVec = null;
        this.targetPath = null;
    }

    void setTarget(BlockPos targetPos) {
        this.targetBlock = this.getBlockFromPos(targetPos);
        this.targetPos = targetPos;
        this.targetVec = this.getVecFromBlockPos(targetPos);
        this.targetPath = this.getSafishPathTo(targetPos);
    }

    void setTarget(BlockPos targetPos, Path targetPath) {
        this.targetBlock = this.getBlockFromPos(targetPos);
        this.targetPos = targetPos;
        this.targetVec = this.getVecFromBlockPos(targetPos);
        this.targetPath = targetPath;
    }

    public boolean hasTarget() {
        return this.targetVec != null;
    }
}

