/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.util.BlocklingType;
import com.blocklings.util.helpers.EntityHelper;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlocklingAIFollowOwner
extends EntityAIBase {
    private final EntityTameable tameable;
    private EntityLivingBase owner;
    World world;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;
    private EntityBlockling blockling;

    public BlocklingAIFollowOwner(EntityTameable tameableIn, float minDistIn, float maxDistIn) {
        this.tameable = tameableIn;
        this.blockling = (EntityBlockling)tameableIn;
        this.world = tameableIn.field_70170_p;
        this.petPathfinder = tameableIn.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
    }

    public boolean func_75250_a() {
        if (this.blockling.getState() != EntityHelper.State.FOLLOW) {
            return false;
        }
        if (this.blockling.hasTarget() || this.blockling.func_70638_az() != null) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.tameable.func_70902_q();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.tameable.func_70906_o()) {
            return false;
        }
        if (this.tameable.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.tameable.func_70906_o();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
        this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 90.0f, (float)this.tameable.func_70646_bf());
        if (!this.tameable.func_70906_o() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (this.blockling.blocklingType.textureName != "slimey_0") {
                if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.5) && !this.tameable.func_110167_bD() && !this.tameable.func_184218_aH() && this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (this.blockling.blocklingType == BlocklingType.blocklingTypes.get(11) || l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                            this.tameable.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.tameable.field_70177_z, this.tameable.field_70125_A);
                            this.petPathfinder.func_75499_g();
                            return;
                        }
                    }
                }
            } else {
                if (this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (this.blockling.blocklingType == BlocklingType.blocklingTypes.get(11) || l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                            this.tameable.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.tameable.field_70177_z, this.tameable.field_70125_A);
                            this.petPathfinder.func_75499_g();
                            return;
                        }
                    }
                }
                this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 90.0f, (float)this.tameable.func_70646_bf());
                ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setDirection(this.blockling.field_70177_z, false);
                ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setSpeed(1.0);
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int p_192381_2_, int y, int p_192381_4_, int p_192381_5_) {
        BlockPos blockpos = new BlockPos(x + p_192381_4_, y - 1, p_192381_2_ + p_192381_5_);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.tameable) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

