/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.abilities;

import com.blocklings.abilities.Ability;
import com.blocklings.abilities.AbilityGroupType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class AbilityGroup {
    public UUID uuid;
    public String groupName;
    public List<Ability> abilities = new ArrayList<Ability>();

    public AbilityGroup() {
    }

    public AbilityGroup(AbilityGroupType type) {
        this.uuid = type.uuid;
        this.groupName = type.name;
        for (Ability ability : type.abilities) {
            this.abilities.add(ability.copy());
        }
    }

    public boolean contains(Ability ability) {
        for (Ability testAbility : this.abilities) {
            if (!testAbility.equals(ability)) continue;
            return true;
        }
        return false;
    }

    private Ability getMatchingAbility(Ability ability) {
        for (Ability testAbility : this.abilities) {
            if (!testAbility.equals(ability)) continue;
            return testAbility;
        }
        return null;
    }

    public boolean isAbilityAcquired(Ability ability) {
        Ability matchingAbility = this.getMatchingAbility(ability);
        return matchingAbility != null && matchingAbility.state == Ability.State.ACQUIRED;
    }

    public void writeToNBT(NBTTagCompound c) {
        for (Ability ability : this.abilities) {
            ability.writeToNBT(c);
        }
    }

    public void initFromNBT(NBTTagCompound c) {
        for (Ability ability : this.abilities) {
            ability.initFromNBT(c, ability.uuid);
        }
        for (Ability ability : this.abilities) {
            for (Ability ability2 : this.abilities) {
                if (ability.parentUuid == null || !ability.parentUuid.equals(ability2.uuid)) continue;
                ability.parentAbility = ability2;
            }
        }
    }

    public void writeToBuf(ByteBuf buf) {
        for (Ability ability : this.abilities) {
            buf.writeInt(ability.state.ordinal());
        }
    }

    public void readFromBuf(ByteBuf buf) {
        for (Ability ability : this.abilities) {
            ability.state = Ability.State.values()[buf.readInt()];
        }
        for (Ability ability : this.abilities) {
            for (Ability ability2 : this.abilities) {
                if (ability.parentUuid == null || !ability.parentUuid.equals(ability2.uuid)) continue;
                ability.parentAbility = ability2;
            }
        }
    }
}

