/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world.dimension;

import baguchan.tofucraft.world.SeedHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TofuBiomeProvider
extends BiomeProvider {
    private static final Noise DEFAULT_NOISE_PARAMETERS = new Noise(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<TofuBiomeProvider> DIRECT_CODEC = RecordCodecBuilder.mapCodec(p_242602_0_ -> p_242602_0_.group((App)Codec.LONG.fieldOf("seed").orElseGet(SeedHolder::getSeed).forGetter(p_235286_0_ -> p_235286_0_.seed), (App)RecordCodecBuilder.create(p_235282_0_ -> p_235282_0_.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.field_235051_b_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)p_235282_0_, Pair::of)).listOf().fieldOf("biomes").forGetter(p_235284_0_ -> p_235284_0_.parameters), (App)Noise.CODEC.fieldOf("temperature_noise").forGetter(p_242608_0_ -> p_242608_0_.temperatureParams), (App)Noise.CODEC.fieldOf("humidity_noise").forGetter(p_242607_0_ -> p_242607_0_.humidityParams), (App)Noise.CODEC.fieldOf("altitude_noise").forGetter(p_242606_0_ -> p_242606_0_.altitudeParams), (App)Noise.CODEC.fieldOf("weirdness_noise").forGetter(p_242604_0_ -> p_242604_0_.weirdnessParams)).apply((Applicative)p_242602_0_, TofuBiomeProvider::new));
    public static final Codec<TofuBiomeProvider> CODEC = Codec.mapEither(DefaultBuilder.CODEC, DIRECT_CODEC).xmap(p_235277_0_ -> (TofuBiomeProvider)((Object)((Object)p_235277_0_.map(DefaultBuilder::biomeSource, Function.identity()))), p_235275_0_ -> p_235275_0_.preset().map(Either::left).orElseGet(() -> Either.right((Object)p_235275_0_))).codec();
    private final Noise temperatureParams;
    private final Noise humidityParams;
    private final Noise altitudeParams;
    private final Noise weirdnessParams;
    private final MaxMinNoiseMixer temperatureNoise;
    private final MaxMinNoiseMixer humidityNoise;
    private final MaxMinNoiseMixer altitudeNoise;
    private final MaxMinNoiseMixer weirdnessNoise;
    private final List<Pair<Biome.Attributes, Supplier<Biome>>> parameters;
    private final boolean useY;
    private final long seed;
    private final Optional<Pair<Registry<Biome>, Preset>> preset;

    private TofuBiomeProvider(long p_i231640_1_, List<Pair<Biome.Attributes, Supplier<Biome>>> p_i231640_3_, Optional<Pair<Registry<Biome>, Preset>> p_i231640_4_) {
        this(p_i231640_1_, p_i231640_3_, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, DEFAULT_NOISE_PARAMETERS, p_i231640_4_);
    }

    private TofuBiomeProvider(long p_i241951_1_, List<Pair<Biome.Attributes, Supplier<Biome>>> p_i241951_3_, Noise p_i241951_4_, Noise p_i241951_5_, Noise p_i241951_6_, Noise p_i241951_7_) {
        this(p_i241951_1_, p_i241951_3_, p_i241951_4_, p_i241951_5_, p_i241951_6_, p_i241951_7_, Optional.empty());
    }

    private TofuBiomeProvider(long p_i241952_1_, List<Pair<Biome.Attributes, Supplier<Biome>>> p_i241952_3_, Noise p_i241952_4_, Noise p_i241952_5_, Noise p_i241952_6_, Noise p_i241952_7_, Optional<Pair<Registry<Biome>, Preset>> p_i241952_8_) {
        super(p_i241952_3_.stream().map(Pair::getSecond));
        this.seed = p_i241952_1_;
        this.preset = p_i241952_8_;
        this.temperatureParams = p_i241952_4_;
        this.humidityParams = p_i241952_5_;
        this.altitudeParams = p_i241952_6_;
        this.weirdnessParams = p_i241952_7_;
        this.temperatureNoise = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(p_i241952_1_), (int)p_i241952_4_.firstOctave(), (DoubleList)p_i241952_4_.amplitudes());
        this.humidityNoise = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(p_i241952_1_ + 1L), (int)p_i241952_5_.firstOctave(), (DoubleList)p_i241952_5_.amplitudes());
        this.altitudeNoise = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(p_i241952_1_ + 2L), (int)p_i241952_6_.firstOctave(), (DoubleList)p_i241952_6_.amplitudes());
        this.weirdnessNoise = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(p_i241952_1_ + 3L), (int)p_i241952_7_.firstOctave(), (DoubleList)p_i241952_7_.amplitudes());
        this.parameters = p_i241952_3_;
        this.useY = false;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long p_230320_1_) {
        return new TofuBiomeProvider(p_230320_1_, this.parameters, this.temperatureParams, this.humidityParams, this.altitudeParams, this.weirdnessParams, this.preset);
    }

    private Optional<DefaultBuilder> preset() {
        return this.preset.map(p_242601_1_ -> new DefaultBuilder((Preset)p_242601_1_.getSecond(), (Registry)p_242601_1_.getFirst(), this.seed));
    }

    public Biome func_225526_b_(int p_225526_1_, int p_225526_2_, int p_225526_3_) {
        int i = this.useY ? p_225526_2_ : 0;
        Biome.Attributes biome$attributes = new Biome.Attributes((float)this.temperatureNoise.func_237211_a_((double)p_225526_1_, (double)i, (double)p_225526_3_), (float)this.humidityNoise.func_237211_a_((double)p_225526_1_, (double)i, (double)p_225526_3_), (float)this.altitudeNoise.func_237211_a_((double)p_225526_1_, (double)i, (double)p_225526_3_), (float)this.weirdnessNoise.func_237211_a_((double)p_225526_1_, (double)i, (double)p_225526_3_), 0.0f);
        return this.parameters.stream().min(Comparator.comparing(p_235272_1_ -> Float.valueOf(((Biome.Attributes)p_235272_1_.getFirst()).func_235110_a_(biome$attributes)))).map(Pair::getSecond).map(Supplier::get).orElse(BiomeRegistry.field_244201_b);
    }

    public boolean stable(long p_235280_1_) {
        return this.seed == p_235280_1_ && this.preset.isPresent() && Objects.equals(this.preset.get().getSecond(), Preset.NETHER);
    }

    public static class Preset {
        private static final Map<ResourceLocation, Preset> BY_NAME = Maps.newHashMap();
        public static final Preset NETHER = new Preset(new ResourceLocation("nether"), (Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider>)((Function3)(p_242617_0_, p_242617_1_, p_242617_2_) -> new TofuBiomeProvider((long)p_242617_2_, (List)ImmutableList.of((Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_242617_1_.func_243576_d(Biomes.field_235254_j_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, -0.5f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_242617_1_.func_243576_d(Biomes.field_235252_ay_)), (Object)Pair.of((Object)new Biome.Attributes(0.4f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)p_242617_1_.func_243576_d(Biomes.field_235253_az_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.5f, 0.0f, 0.0f, 0.375f), () -> (Biome)p_242617_1_.func_243576_d(Biomes.field_235250_aA_)), (Object)Pair.of((Object)new Biome.Attributes(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f), () -> (Biome)p_242617_1_.func_243576_d(Biomes.field_235251_aB_))), Optional.of(Pair.of((Object)p_242617_1_, (Object)p_242617_0_)))));
        private final ResourceLocation name;
        private final Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider> biomeSource;

        public Preset(ResourceLocation p_i241955_1_, Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider> p_i241955_2_) {
            this.name = p_i241955_1_;
            this.biomeSource = p_i241955_2_;
            BY_NAME.put(p_i241955_1_, this);
        }

        public TofuBiomeProvider biomeSource(Registry<Biome> p_242619_1_, long p_242619_2_) {
            return (TofuBiomeProvider)((Object)this.biomeSource.apply((Object)this, p_242619_1_, (Object)p_242619_2_));
        }
    }

    static class Noise {
        private final int firstOctave;
        private final DoubleList amplitudes;
        public static final Codec<Noise> CODEC = RecordCodecBuilder.create(p_242613_0_ -> p_242613_0_.group((App)Codec.INT.fieldOf("firstOctave").forGetter(Noise::firstOctave), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(Noise::amplitudes)).apply((Applicative)p_242613_0_, Noise::new));

        public Noise(int p_i241954_1_, List<Double> p_i241954_2_) {
            this.firstOctave = p_i241954_1_;
            this.amplitudes = new DoubleArrayList(p_i241954_2_);
        }

        public int firstOctave() {
            return this.firstOctave;
        }

        public DoubleList amplitudes() {
            return this.amplitudes;
        }
    }

    static final class DefaultBuilder {
        public static final MapCodec<DefaultBuilder> CODEC = RecordCodecBuilder.mapCodec(p_242630_0_ -> p_242630_0_.group((App)ResourceLocation.field_240908_a_.flatXmap(p_242631_0_ -> Optional.ofNullable(Preset.BY_NAME.get(p_242631_0_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + p_242631_0_))), p_242629_0_ -> DataResult.success((Object)((Preset)p_242629_0_).name)).fieldOf("preset").stable().forGetter(DefaultBuilder::preset), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(DefaultBuilder::biomes), (App)Codec.LONG.fieldOf("seed").stable().forGetter(DefaultBuilder::seed)).apply((Applicative)p_242630_0_, p_242630_0_.stable(DefaultBuilder::new)));
        private final Preset preset;
        private final Registry<Biome> biomes;
        private final long seed;

        private DefaultBuilder(Preset p_i241956_1_, Registry<Biome> p_i241956_2_, long p_i241956_3_) {
            this.preset = p_i241956_1_;
            this.biomes = p_i241956_2_;
            this.seed = p_i241956_3_;
        }

        public Preset preset() {
            return this.preset;
        }

        public Registry<Biome> biomes() {
            return this.biomes;
        }

        public long seed() {
            return this.seed;
        }

        public TofuBiomeProvider biomeSource() {
            return this.preset.biomeSource(this.biomes, this.seed);
        }
    }
}

