/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileScanner {
    private final World world;
    private final BlockPos centrePos;

    public TileScanner(World world, BlockPos pos) {
        this.world = world;
        this.centrePos = pos;
    }

    public <T> T scan(int size, Impl<T> impl) {
        return this.scan(size, Method.partial, impl);
    }

    public <T> T scan(int size, Method method, Impl<T> impl) {
        impl.pos = this.centrePos;
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos absTargPos = this.centrePos.func_177982_a(x, y, z);
                    method.impl.apply(this.world, new BlockPos(x, y, z), absTargPos, size, impl);
                }
            }
        }
        return impl.getReturn();
    }

    public static abstract class Impl<T> {
        public BlockPos pos;

        public abstract void apply(World var1, BlockPos var2);

        public T getReturn() {
            return null;
        }
    }

    private static interface IScanMethod {
        public void apply(World var1, BlockPos var2, BlockPos var3, int var4, Impl<?> var5);
    }

    public static enum Method {
        partial(new IScanMethod(){

            @Override
            public void apply(World world, BlockPos relPos, BlockPos absTargPos, int size, Impl<?> impl) {
                int dist = Math.abs(relPos.func_177958_n()) + Math.abs(relPos.func_177956_o()) + Math.abs(relPos.func_177952_p());
                if (dist == size) {
                    impl.apply(world, absTargPos);
                }
            }
        }),
        full(new IScanMethod(){

            @Override
            public void apply(World world, BlockPos relPos, BlockPos absTargPos, int size, Impl<?> impl) {
                int dist = Math.abs(relPos.func_177958_n()) + Math.abs(relPos.func_177956_o()) + Math.abs(relPos.func_177952_p());
                if (dist <= size) {
                    impl.apply(world, absTargPos);
                }
            }
        }),
        fullSimply(new IScanMethod(){

            @Override
            public void apply(World world, BlockPos relPos, BlockPos absTagPos, int size, Impl<?> impl) {
                impl.apply(world, absTagPos);
            }
        });

        public IScanMethod impl;

        private Method(IScanMethod impl) {
            this.impl = impl;
        }
    }
}

