/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.entity.AbstractTofunianEntity;
import baguchan.tofucraft.entity.ai.CropHarvestGoal;
import baguchan.tofucraft.entity.ai.DoSleepingGoal;
import baguchan.tofucraft.entity.ai.FindJobBlockGoal;
import baguchan.tofucraft.entity.ai.MakeFoodGoal;
import baguchan.tofucraft.entity.ai.RestockGoal;
import baguchan.tofucraft.entity.ai.ShareItemGoal;
import baguchan.tofucraft.entity.ai.SleepOnBedGoal;
import baguchan.tofucraft.entity.ai.TofunianLoveGoal;
import baguchan.tofucraft.entity.ai.WakeUpGoal;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuTrades;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.util.ITeleporter;

public class TofunianEntity
extends AbstractTofunianEntity
implements IReputationTracking {
    private static final DataParameter<String> ROLE = EntityDataManager.func_187226_a(TofunianEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final Map<Item, Integer> FOOD_POINTS = ImmutableMap.of((Object)TofuItems.SOYMILK, (Object)5, (Object)TofuItems.TOFUCOOKIE, (Object)3, (Object)TofuItems.TOFUGRILLED, (Object)2);
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)TofuItems.SOYMILK, (Object)TofuItems.TOFUCOOKIE, (Object)TofuItems.TOFUGRILLED, (Object)TofuItems.SEEDS_SOYBEANS);
    private byte foodLevel;
    @Nullable
    private BlockPos tofunainHome;
    @Nullable
    private BlockPos tofunainJobBlock;
    private final GossipManager gossip = new GossipManager();
    private long lastGossipDecay;
    private long lastRestock;
    private int restocksToday;
    private long lastRestockDayTime;
    private int timeUntilReset;
    private boolean leveledUp;
    @Nullable
    private PlayerEntity previousCustomer;
    private int xp;
    private int tofunianLevel = 1;

    public TofunianEntity(EntityType<? extends TofunianEntity> type, World worldIn) {
        super(type, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new WakeUpGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DoSleepingGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractIllagerEntity.class, 12.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, RavagerEntity.class, 12.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZoglinEntity.class, 10.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SleepOnBedGoal(this, 1.0, 8));
        this.field_70714_bg.func_75776_a(3, (Goal)new TofunianLoveGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FindJobBlockGoal(this, 1.0, 8));
        this.field_70714_bg.func_75776_a(4, (Goal)new RestockGoal(this, 1.15f, 6));
        this.field_70714_bg.func_75776_a(4, (Goal)new MakeFoodGoal(this, 1.1f, 6));
        this.field_70714_bg.func_75776_a(4, (Goal)new CropHarvestGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new ShareItemGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.24f).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)TofuEntityTypes.TOFUNIAN.func_200721_a((World)p_241840_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROLE, (Object)Roles.TOFUNIAN.name());
    }

    public void setRole(Roles role) {
        this.field_70180_af.func_187227_b(ROLE, (Object)role.name());
    }

    public Roles getRole() {
        return Roles.get((String)this.field_70180_af.func_187225_a(ROLE));
    }

    public void setTofunainHome(@Nullable BlockPos pos) {
        this.tofunainHome = pos;
    }

    @Nullable
    public BlockPos getTofunainHome() {
        return this.tofunainHome;
    }

    public void setTofunainJobBlock(@Nullable BlockPos tofunainJobBlock) {
        this.tofunainJobBlock = tofunainJobBlock;
    }

    @Nullable
    public BlockPos getTofunainJobBlock() {
        return this.tofunainJobBlock;
    }

    @Nullable
    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        this.setTofunainHome(null);
        if (this.xp != 0) {
            this.setTofunainJobBlock(null);
        }
        return super.changeDimension(server, teleporter);
    }

    protected void func_70619_bc() {
        if (!this.func_213716_dX() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.leveledUp) {
                    this.increaseMerchantCareer();
                    this.leveledUp = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.previousCustomer != null && this.func_190670_t_() instanceof ServerWorld) {
            ((ServerWorld)this.func_190670_t_()).func_217489_a(IReputationType.field_221033_e, (Entity)this.previousCustomer, (IReputationTracking)this);
            this.func_190670_t_().func_72960_a((Entity)this, (byte)14);
            this.previousCustomer = null;
        }
        if (this.getRole() == Roles.TOFUNIAN && this.func_213716_dX()) {
            this.func_213750_eg();
        }
        super.func_70619_bc();
    }

    public void func_213739_a(IReputationType p_213739_1_, Entity p_213739_2_) {
        if (p_213739_1_ == IReputationType.field_221029_a) {
            this.gossip.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MAJOR_POSITIVE, 20);
            this.gossip.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MINOR_POSITIVE, 25);
        } else if (p_213739_1_ == IReputationType.field_221033_e) {
            this.gossip.func_220916_a(p_213739_2_.func_110124_au(), GossipType.TRADING, 2);
        } else if (p_213739_1_ == IReputationType.field_221031_c) {
            this.gossip.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (p_213739_1_ == IReputationType.field_221032_d) {
            this.gossip.func_220916_a(p_213739_2_.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        this.previousCustomer = this.func_70931_l_();
        if (this.canLevelUp()) {
            this.timeUntilReset = 40;
            this.leveledUp = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.func_190670_t_().func_217376_c((Entity)new ExperienceOrbEntity(this.func_190670_t_(), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() != TofuItems.TOFUNIAN_SPAWNEGG && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (this.func_70631_g_()) {
                this.shakeHead();
                return ActionResultType.func_233537_a_((boolean)this.func_190670_t_().func_201670_d());
            }
            boolean flag = this.func_213706_dY().isEmpty();
            if (p_230254_2_ == Hand.MAIN_HAND) {
                if (flag && !this.func_190670_t_().func_201670_d()) {
                    this.shakeHead();
                }
                p_230254_1_.func_195066_a(Stats.field_188075_I);
            }
            if (flag) {
                return ActionResultType.func_233537_a_((boolean)this.func_190670_t_().func_201670_d());
            }
            if (!this.func_190670_t_().func_201670_d() && !this.field_213724_bz.isEmpty()) {
                this.displayMerchantGui(p_230254_1_);
            }
            return ActionResultType.func_233537_a_((boolean)this.func_190670_t_().func_201670_d());
        }
        return ActionResultType.func_233537_a_((boolean)this.func_190670_t_().func_201670_d());
    }

    private void displayMerchantGui(PlayerEntity player) {
        this.recalculateSpecialPricesFor(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, this.func_145748_c_(), this.tofunianLevel);
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        boolean flag = this.func_70931_l_() != null && player == null;
        super.func_70932_a_(player);
        if (flag) {
            this.func_213750_eg();
        }
    }

    protected void func_213750_eg() {
        super.func_213750_eg();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222220_k();
        }
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void restock() {
        this.calculateDemandOfOffers();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        this.lastRestock = this.func_190670_t_().func_82737_E();
        ++this.restocksToday;
    }

    private boolean allowedToRestock() {
        return this.restocksToday == 0 || this.restocksToday < 2 && this.func_190670_t_().func_82737_E() > this.lastRestock + 2400L;
    }

    public boolean canResetStock() {
        long i = this.lastRestock + 12000L;
        long j = this.field_70170_p.func_82737_E();
        boolean flag = j > i;
        long k = this.field_70170_p.func_72820_D();
        if (this.lastRestockDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockDayTime = k;
        if (flag) {
            this.lastRestock = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.hasUsedOffer();
    }

    private void resetNumberOfRestocks() {
        this.resetOffersAndAdjustForDemand();
        this.restocksToday = 0;
    }

    private void resetOffersAndAdjustForDemand() {
        int i = 2 - this.restocksToday;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.calculateDemandOfOffers();
        }
    }

    private boolean hasUsedOffer() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private void calculateDemandOfOffers() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    private void recalculateSpecialPricesFor(PlayerEntity playerIn) {
        int i = this.getPlayerReputation(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
    }

    public void setOffers(MerchantOffers offersIn) {
        this.field_213724_bz = offersIn;
    }

    private boolean canLevelUp() {
        int i = this.tofunianLevel;
        return VillagerData.func_221128_d((int)i) && this.xp >= VillagerData.func_221127_c((int)i);
    }

    private void increaseMerchantCareer() {
        this.setTofunainLevel(this.tofunianLevel + 1);
        this.func_213712_ef();
    }

    public void setTofunainLevel(int level) {
        this.tofunianLevel = level;
    }

    public int getTofunainLevel() {
        return this.tofunianLevel;
    }

    public int getPlayerReputation(PlayerEntity player) {
        return this.gossip.func_220921_a(player.func_110124_au(), gossipType -> true);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("FoodLevel", this.foodLevel);
        compound.func_218657_a("Gossips", (INBT)this.gossip.func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        compound.func_74768_a("Xp", this.xp);
        compound.func_74768_a("Level", this.tofunianLevel);
        compound.func_74772_a("LastRestock", this.lastRestock);
        compound.func_74772_a("LastGossipDecay", this.lastGossipDecay);
        compound.func_74768_a("RestocksToday", this.restocksToday);
        if (this.tofunainHome != null) {
            compound.func_218657_a("TofunianHome", (INBT)NBTUtil.func_186859_a((BlockPos)this.tofunainHome));
        }
        if (this.tofunainJobBlock != null) {
            compound.func_218657_a("TofunianJobBlock", (INBT)NBTUtil.func_186859_a((BlockPos)this.tofunainJobBlock));
        }
        compound.func_74778_a("Roles", this.getRole().name());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("FoodLevel", 1)) {
            this.foodLevel = compound.func_74771_c("FoodLevel");
        }
        ListNBT listnbt = compound.func_150295_c("Gossips", 10);
        this.gossip.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)listnbt));
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        if (compound.func_74764_b("Level")) {
            this.tofunianLevel = compound.func_74762_e("Level");
        }
        this.lastGossipDecay = compound.func_74763_f("LastGossipDecay");
        this.lastRestock = compound.func_74763_f("LastRestock");
        this.restocksToday = compound.func_74762_e("RestocksToday");
        if (compound.func_74764_b("TofunianHome")) {
            this.tofunainHome = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TofunianHome"));
        }
        if (compound.func_74764_b("TofunianJobBlock")) {
            this.tofunainJobBlock = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TofunianJobBlock"));
        }
        if (compound.func_74764_b("Roles")) {
            this.setRole(Roles.get(compound.func_74779_i("Roles")));
        }
        this.func_98053_h(true);
    }

    public int func_213708_dV() {
        return this.xp;
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.func_92059_d();
        if (this.func_230293_i_(itemstack)) {
            Inventory inventory = this.func_213715_ed();
            boolean flag = inventory.func_233541_b_(itemstack);
            if (!flag) {
                return;
            }
            this.func_233630_a_(p_175445_1_);
            this.func_71001_a((Entity)p_175445_1_, itemstack.func_190916_E());
            ItemStack itemstack1 = inventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                p_175445_1_.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean func_213743_em() {
        return this.foodLevel + this.countFoodPointsInInventory() >= 32 && this.func_70874_b() == 0;
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    private void eatUntilFull() {
        if (this.hungry() && this.countFoodPointsInInventory() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
                if (itemstack.func_190926_b() || (integer = FOOD_POINTS.get(itemstack.func_77973_b())) == null) continue;
                for (int k = j = itemstack.func_190916_E(); k > 0; --k) {
                    this.foodLevel = (byte)(this.foodLevel + integer);
                    this.func_213715_ed().func_70298_a(i, 1);
                    if (this.hungry()) continue;
                    return;
                }
            }
        }
    }

    public boolean func_230293_i_(ItemStack p_230293_1_) {
        Item item = p_230293_1_.func_77973_b();
        return WANTED_ITEMS.contains(item) && this.func_213715_ed().func_233541_b_(p_230293_1_);
    }

    public boolean hasExcessFood() {
        return this.countFoodPointsInInventory() >= 32;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 24;
    }

    public boolean hasFarmSeeds() {
        return this.func_213715_ed().func_213902_a((Set)ImmutableSet.of((Object)TofuItems.SEEDS_SOYBEANS));
    }

    private int countFoodPointsInInventory() {
        Inventory inventory = this.func_213715_ed();
        return FOOD_POINTS.entrySet().stream().mapToInt(p_226553_1_ -> inventory.func_213901_a((Item)p_226553_1_.getKey()) * (Integer)p_226553_1_.getValue()).sum();
    }

    public void cookingFood() {
        for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
            if (itemstack.func_190926_b() || itemstack.func_77973_b() != TofuItems.SEEDS_SOYBEANS) continue;
            this.func_213715_ed().func_70298_a(i, 1);
            this.cookResult();
        }
    }

    private void cookResult() {
        this.func_213715_ed().func_174894_a(new ItemStack((IItemProvider)TofuItems.TOFUGRILLED));
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        Int2ObjectMap<VillagerTrades.ITrade[]> int2objectmap = TofuTrades.TOFUNIAN_TRADE.get((Object)this.getRole());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(this.tofunianLevel)) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickGossip();
    }

    private void tickGossip() {
        long i = this.func_190670_t_().func_82737_E();
        if (this.lastGossipDecay == 0L) {
            this.lastGossipDecay = i;
        } else if (i >= this.lastGossipDecay + 24000L) {
            this.gossip.func_223538_b();
            this.lastGossipDecay = i;
        }
    }

    public GossipManager getGossip() {
        return this.gossip;
    }

    public void setGossips(INBT gossip) {
        this.gossip.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gossip));
    }

    public void func_70604_c(@Nullable LivingEntity p_70604_1_) {
        if (p_70604_1_ != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, (Entity)p_70604_1_, (IReputationTracking)this);
            if (this.func_70089_S() && p_70604_1_ instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)13);
            }
        }
        super.func_70604_c(p_70604_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 12) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197633_z);
        } else if (p_70103_1_ == 13) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197609_b);
        } else if (p_70103_1_ == 14) {
            this.func_213718_a((IParticleData)ParticleTypes.field_197632_y);
        } else if (p_70103_1_ == 42) {
            this.func_213718_a((IParticleData)ParticleTypes.field_218422_X);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public static enum Roles implements IExtensibleEnum
    {
        TOFUCOOK,
        TOFUSMITH,
        SOYWORKER,
        TOFUNIAN;

        private static final Map<String, Roles> lookup;

        public static Roles create(String name) {
            throw new IllegalStateException("Enum not extended");
        }

        public static Roles get(String nameIn) {
            for (Roles role : Roles.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return TOFUNIAN;
        }

        static {
            lookup = Arrays.stream(Roles.values()).collect(Collectors.toMap(Enum::name, p_220362_0_ -> p_220362_0_));
        }
    }
}

