/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.tileentity.TofuBedTileEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

public class TofuBedBlock
extends HorizontalBlock
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});

    public TofuBedBlock(AbstractBlock.Properties p_i48442_2_) {
        super(p_i48442_2_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Direction getBedOrientation(IBlockReader p_220174_0_, BlockPos p_220174_1_) {
        BlockState blockstate = p_220174_0_.func_180495_p(p_220174_1_);
        return blockstate.func_177230_c() instanceof TofuBedBlock ? (Direction)blockstate.func_177229_b((Property)field_185512_D) : null;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (p_225533_1_.func_177229_b(PART) != BedPart.HEAD && !(p_225533_1_ = p_225533_2_.func_180495_p(p_225533_3_ = p_225533_3_.func_177972_a((Direction)p_225533_1_.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!TofuBedBlock.canSetSpawn(p_225533_2_)) {
            p_225533_2_.func_217377_a(p_225533_3_, false);
            BlockPos blockpos = p_225533_3_.func_177972_a(((Direction)p_225533_1_.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (p_225533_2_.func_180495_p(blockpos).func_203425_a((Block)this)) {
                p_225533_2_.func_217377_a(blockpos, false);
            }
            p_225533_2_.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)p_225533_3_.func_177958_n() + 0.5, (double)p_225533_3_.func_177956_o() + 0.5, (double)p_225533_3_.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)p_225533_1_.func_177229_b((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(p_225533_2_, p_225533_3_)) {
                p_225533_4_.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        p_225533_4_.func_213819_a(p_225533_3_).ifLeft(p_220173_1_ -> {
            if (p_220173_1_ != null) {
                p_225533_4_.func_146105_b(p_220173_1_.func_221259_a(), true);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public static boolean canSetSpawn(World p_235330_0_) {
        return p_235330_0_.func_230315_m_().func_241510_j_();
    }

    private boolean kickVillagerOutOfBed(World p_226861_1_, BlockPos p_226861_2_) {
        List list = p_226861_1_.func_175647_a(VillagerEntity.class, new AxisAlignedBB(p_226861_2_), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    public void func_180658_a(World p_180658_1_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        super.func_180658_a(p_180658_1_, p_180658_2_, p_180658_3_, p_180658_4_ * 0.5f);
    }

    public void func_176216_a(IBlockReader p_176216_1_, Entity p_176216_2_) {
        if (p_176216_2_.func_226272_bl_()) {
            super.func_176216_a(p_176216_1_, p_176216_2_);
        } else {
            this.bounceUp(p_176216_2_);
        }
    }

    private void bounceUp(Entity p_226860_1_) {
        Vector3d vector3d = p_226860_1_.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = p_226860_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226860_1_.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_2_ == TofuBedBlock.getNeighbourDirection((BedPart)p_196271_1_.func_177229_b(PART), (Direction)p_196271_1_.func_177229_b((Property)field_185512_D))) {
            return p_196271_3_.func_203425_a((Block)this) && p_196271_3_.func_177229_b(PART) != p_196271_1_.func_177229_b(PART) ? (BlockState)p_196271_1_.func_206870_a((Property)OCCUPIED, p_196271_3_.func_177229_b((Property)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    private static Direction getNeighbourDirection(BedPart p_208070_0_, Direction p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    public void func_176208_a(World p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, PlayerEntity p_176208_4_) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!p_176208_1_.field_72995_K && p_176208_4_.func_184812_l_() && (bedpart = (BedPart)p_176208_3_.func_177229_b(PART)) == BedPart.FOOT && (blockstate = p_176208_1_.func_180495_p(blockpos = p_176208_2_.func_177972_a(TofuBedBlock.getNeighbourDirection(bedpart, (Direction)p_176208_3_.func_177229_b((Property)field_185512_D))))).func_177230_c() == this && blockstate.func_177229_b(PART) == BedPart.HEAD) {
            p_176208_1_.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            p_176208_1_.func_217378_a(p_176208_4_, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        Direction direction = p_196258_1_.func_195992_f();
        BlockPos blockpos = p_196258_1_.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return p_196258_1_.func_195991_k().func_180495_p(blockpos1).func_196953_a(p_196258_1_) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = TofuBedBlock.getConnectedDirection(p_220053_1_).func_176734_d();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState p_226862_0_) {
        Direction direction = (Direction)p_226862_0_.func_177229_b((Property)field_185512_D);
        return p_226862_0_.func_177229_b(PART) == BedPart.HEAD ? direction.func_176734_d() : direction;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.Type getBlockType(BlockState p_226863_0_) {
        BedPart bedpart = (BedPart)p_226863_0_.func_177229_b(PART);
        return bedpart == BedPart.HEAD ? TileEntityMerger.Type.FIRST : TileEntityMerger.Type.SECOND;
    }

    private static boolean isBunkBed(IBlockReader p_242657_0_, BlockPos p_242657_1_) {
        return p_242657_0_.func_180495_p(p_242657_1_.func_177977_b()).func_177230_c() instanceof TofuBedBlock;
    }

    public static Optional<Vector3d> findStandUpPosition(EntityType<?> p_242652_0_, ICollisionReader p_242652_1_, BlockPos p_242652_2_, float p_242652_3_) {
        Direction direction2;
        Direction direction = (Direction)p_242652_1_.func_180495_p(p_242652_2_).func_177229_b((Property)field_185512_D);
        Direction direction1 = direction.func_176746_e();
        Direction direction3 = direction2 = direction1.func_243532_a(p_242652_3_) ? direction1.func_176734_d() : direction1;
        if (TofuBedBlock.isBunkBed((IBlockReader)p_242652_1_, p_242652_2_)) {
            return TofuBedBlock.findBunkBedStandUpPosition(p_242652_0_, p_242652_1_, p_242652_2_, direction, direction2);
        }
        int[][] aint = TofuBedBlock.bedStandUpOffsets(direction, direction2);
        Optional<Vector3d> optional = TofuBedBlock.findStandUpPositionAtOffset(p_242652_0_, p_242652_1_, p_242652_2_, aint, true);
        return optional.isPresent() ? optional : TofuBedBlock.findStandUpPositionAtOffset(p_242652_0_, p_242652_1_, p_242652_2_, aint, false);
    }

    private static Optional<Vector3d> findBunkBedStandUpPosition(EntityType<?> p_242653_0_, ICollisionReader p_242653_1_, BlockPos p_242653_2_, Direction p_242653_3_, Direction p_242653_4_) {
        int[][] aint = TofuBedBlock.bedSurroundStandUpOffsets(p_242653_3_, p_242653_4_);
        Optional<Vector3d> optional = TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, p_242653_2_, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockpos = p_242653_2_.func_177977_b();
        Optional<Vector3d> optional1 = TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, blockpos, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = TofuBedBlock.bedAboveStandUpOffsets(p_242653_3_);
        Optional<Vector3d> optional2 = TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, p_242653_2_, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vector3d> optional3 = TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, p_242653_2_, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vector3d> optional4 = TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, blockpos, aint, false);
        return optional4.isPresent() ? optional4 : TofuBedBlock.findStandUpPositionAtOffset(p_242653_0_, p_242653_1_, p_242653_2_, aint1, false);
    }

    private static Optional<Vector3d> findStandUpPositionAtOffset(EntityType<?> p_242654_0_, ICollisionReader p_242654_1_, BlockPos p_242654_2_, int[][] p_242654_3_, boolean p_242654_4_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int[] aint : p_242654_3_) {
            blockpos$mutable.func_181079_c(p_242654_2_.func_177958_n() + aint[0], p_242654_2_.func_177956_o(), p_242654_2_.func_177952_p() + aint[1]);
            Vector3d vector3d = TransportationHelper.func_242379_a(p_242654_0_, (ICollisionReader)p_242654_1_, (BlockPos)blockpos$mutable, (boolean)p_242654_4_);
            if (vector3d == null) continue;
            return Optional.of(vector3d);
        }
        return Optional.empty();
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_185512_D, PART, OCCUPIED});
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new TofuBedTileEntity();
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, @Nullable LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        super.func_180633_a(p_180633_1_, p_180633_2_, p_180633_3_, p_180633_4_, p_180633_5_);
        if (!p_180633_1_.field_72995_K) {
            BlockPos blockpos = p_180633_2_.func_177972_a((Direction)p_180633_3_.func_177229_b((Property)field_185512_D));
            p_180633_1_.func_180501_a(blockpos, (BlockState)p_180633_3_.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            p_180633_1_.func_230547_a_(p_180633_2_, Blocks.field_150350_a);
            p_180633_3_.func_235734_a_((IWorld)p_180633_1_, p_180633_2_, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState p_209900_1_, BlockPos p_209900_2_) {
        BlockPos blockpos = p_209900_2_.func_177967_a((Direction)p_209900_1_.func_177229_b((Property)field_185512_D), p_209900_1_.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)p_209900_2_.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction p_242656_0_, Direction p_242656_1_) {
        return (int[][])ArrayUtils.addAll((Object[])TofuBedBlock.bedSurroundStandUpOffsets(p_242656_0_, p_242656_1_), (Object[])TofuBedBlock.bedAboveStandUpOffsets(p_242656_0_));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction p_242658_0_, Direction p_242658_1_) {
        return new int[][]{{p_242658_1_.func_82601_c(), p_242658_1_.func_82599_e()}, {p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c(), p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e()}, {p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c() * 2, p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e() * 2}, {-p_242658_0_.func_82601_c() * 2, -p_242658_0_.func_82599_e() * 2}, {-p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c() * 2, -p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e() * 2}, {-p_242658_1_.func_82601_c() - p_242658_0_.func_82601_c(), -p_242658_1_.func_82599_e() - p_242658_0_.func_82599_e()}, {-p_242658_1_.func_82601_c(), -p_242658_1_.func_82599_e()}, {-p_242658_1_.func_82601_c() + p_242658_0_.func_82601_c(), -p_242658_1_.func_82599_e() + p_242658_0_.func_82599_e()}, {p_242658_0_.func_82601_c(), p_242658_0_.func_82599_e()}, {p_242658_1_.func_82601_c() + p_242658_0_.func_82601_c(), p_242658_1_.func_82599_e() + p_242658_0_.func_82599_e()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction p_242655_0_) {
        return new int[][]{{0, 0}, {-p_242655_0_.func_82601_c(), -p_242655_0_.func_82599_e()}};
    }
}

