/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.utils.TileScanner;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class SaltPanBlock
extends Block
implements IWaterLoggable {
    public static VoxelShape SALT_PAN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final EnumProperty<Stat> STAT = EnumProperty.func_177709_a((String)"stat", Stat.class);
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SaltPanBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            Stat stat = this.getStat(stateIn);
            if (stat == Stat.EMPTY || stat == Stat.BITTERN) {
                worldIn.func_180501_a(currentPos, (BlockState)stateIn.func_206870_a(STAT, (Comparable)((Object)Stat.WATER)), 3);
            } else if (stat == Stat.SALT) {
                ItemStack salt = new ItemStack((IItemProvider)TofuItems.SALT, 1);
                if (worldIn instanceof World) {
                    float f = 0.7f;
                    double d0 = (double)(worldIn.func_201674_k().nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(worldIn.func_201674_k().nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                    double d2 = (double)(worldIn.func_201674_k().nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    ItemEntity itemEntity = new ItemEntity((World)worldIn, (double)currentPos.func_177958_n() + d0, (double)currentPos.func_177956_o() + d1, (double)currentPos.func_177952_p() + d2, salt);
                    itemEntity.func_174867_a(10);
                    worldIn.func_217376_c((Entity)itemEntity);
                }
                worldIn.func_180501_a(currentPos, (BlockState)stateIn.func_206870_a(STAT, (Comparable)((Object)Stat.WATER)), 3);
            }
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.func_177978_c())))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.func_177974_f())))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.func_177968_d())))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.func_177976_e()))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return blockstate.func_177230_c() == this ? (BlockState)((BlockState)((BlockState)((BlockState)context.func_195991_k().func_180495_p(context.func_195995_a()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)context.func_195991_k(), context.func_195995_a().func_177978_c())))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)context.func_195991_k(), context.func_195995_a().func_177974_f())))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)context.func_195991_k(), context.func_195995_a().func_177968_d())))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)context.func_195991_k(), context.func_195995_a().func_177976_e()))) : super.func_196258_a(context);
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return p_196260_2_.func_180495_p(p_196260_3_.func_177977_b()).func_185904_a().func_76220_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemHeld = player.func_184586_b(handIn);
        Stat stat = this.getStat(state);
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            if (stat == Stat.EMPTY && itemHeld != null && itemHeld.func_77973_b() == Items.field_151131_as) {
                if (!player.func_184812_l_()) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                TileScanner tileScanner = new TileScanner(worldIn, pos);
                tileScanner.scan(1, TileScanner.Method.fullSimply, new TileScanner.Impl<Object>(){

                    @Override
                    public void apply(World world, BlockPos pos) {
                        if (SaltPanBlock.this.getStat(world.func_180495_p(pos)) == Stat.EMPTY) {
                            world.func_180501_a(pos, (BlockState)TofuBlocks.SALTPAN.func_176223_P().func_206870_a(STAT, (Comparable)((Object)Stat.WATER)), 3);
                        }
                    }
                });
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.WATER)), 3);
                return ActionResultType.SUCCESS;
            }
            if (stat == Stat.BITTERN && itemHeld != null && itemHeld.func_77973_b() == Items.field_151069_bo) {
                ItemStack nigari = new ItemStack((IItemProvider)TofuItems.BITTERN);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (itemHeld.func_190916_E() == 1) {
                    player.func_184611_a(handIn, nigari);
                } else {
                    if (!player.field_71071_by.func_70441_a(nigari)) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, nigari));
                    }
                    itemHeld.func_190918_g(1);
                }
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.EMPTY)), 3);
                return ActionResultType.SUCCESS;
            }
            if (stat == Stat.BITTERN && itemHeld == null) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.EMPTY)), 3);
                return ActionResultType.SUCCESS;
            }
            if (stat == Stat.SALT) {
                ItemStack salt = new ItemStack((IItemProvider)TofuItems.SALT, 1);
                float f = 0.7f;
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, salt);
                itemEntity.func_174867_a(10);
                worldIn.func_217376_c((Entity)itemEntity);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.BITTERN)), 3);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        float f;
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
        Stat stat = this.getStat(state);
        int l = stat.getMeta();
        if (stat == Stat.WATER && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && (f = this.calcAdaptation((World)worldIn, pos)) > 0.0f && random.nextInt((int)(25.0f / f) + 1) == 0) {
            ++l;
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.SALT)), 2);
        }
    }

    public Stat getStat(BlockState meta) {
        if (meta.func_177230_c() == this) {
            return (Stat)((Object)meta.func_177229_b(STAT));
        }
        return Stat.NA;
    }

    public boolean canConnectTo(IWorld worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block instanceof SaltPanBlock;
    }

    private float calcAdaptation(World world, BlockPos pos) {
        float rate;
        Biome biome = world.func_226691_t_(pos);
        boolean isUnderTheSun = world.func_226660_f_(pos);
        boolean isRaining = world.func_72896_J();
        boolean isDaytime = world.func_241851_ab() % 24000L < 12000L;
        float humidity = biome.func_76727_i();
        float temperature = biome.func_225486_c(pos);
        if (!isUnderTheSun || isRaining) {
            rate = 0.0f;
        } else {
            rate = isDaytime ? 2.0f : 1.0f;
            rate = (float)((double)rate * ((double)humidity < 0.2 ? 4.0 : ((double)humidity < 0.7 ? 2.0 : ((double)humidity < 0.9 ? 1.0 : 0.5))));
            rate = (float)((double)rate * ((double)temperature < 0.0 ? 1.0 : ((double)temperature < 0.6 ? 1.5 : ((double)temperature < 1.0 ? 2.0 : 4.0))));
        }
        return rate;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SALT_PAN_AABB;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAT, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public static enum Stat implements IStringSerializable
    {
        EMPTY(0, "empty"),
        WATER(1, "water"),
        SALT(2, "salt"),
        BITTERN(3, "bittern"),
        NA(4, "na");

        private static final Stat[] META_LOOKUP;
        private final int meta;
        private final String name;

        private Stat(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static Stat byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new Stat[Stat.values().length];
            Stat[] statArray = Stat.values();
            int n = statArray.length;
            for (int i = 0; i < n; ++i) {
                Stat enumtype;
                Stat.META_LOOKUP[enumtype.getMeta()] = enumtype = statArray[i];
            }
        }
    }
}

