/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KinuTofuBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;

    public KinuTofuBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos) && rand.nextInt(4) == 0) {
            double d4 = rand.nextBoolean() ? 0.8 : -0.8;
            double d0 = (double)pos.func_177958_n() + 0.5 + (double)rand.nextFloat() * d4;
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + 0.5 + (double)rand.nextFloat() * d4;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.75f);
        worldIn.func_175655_b(pos, true);
    }

    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        super.func_225542_b_(p_225542_1_, p_225542_2_, p_225542_3_, p_225542_4_);
        if (this.isUnderWeight((World)p_225542_2_, p_225542_3_)) {
            p_225542_2_.func_175655_b(p_225542_3_, true);
        }
    }

    public boolean isUnderWeight(World world, BlockPos pos) {
        BlockState weightBlock = world.func_180495_p(pos.func_177984_a());
        BlockState baseBlock = world.func_180495_p(pos.func_177977_b());
        boolean isWeightValid = weightBlock != null && (weightBlock.func_185904_a() == Material.field_151576_e || weightBlock.func_185904_a() == Material.field_151573_f || weightBlock.func_185904_a() == Material.field_151574_g);
        float baseHardness = baseBlock.func_185887_b((IBlockReader)world, pos.func_177977_b());
        boolean isBaseValid = baseBlock.func_235785_r_((IBlockReader)world, pos) && (baseBlock.func_185904_a() == Material.field_151576_e || baseBlock.func_185904_a() == Material.field_151573_f || baseHardness >= 1.0f || baseHardness < 0.0f);
        return isWeightValid && isBaseValid;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }
}

